/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xfs_mount();
const commandtable_t command_xfs_mount =
	{"xfs_mount", xfs_mount, "[-i] [-l] address", "[XFS] print xfs_mount_t table\n  -i  print xfs_inode table\n  -l  print xfs_log_item table"};
extern addr_t print_xfs_mount();

PRIVATE addr_t xfs_perag();
const commandtable_t command_xfs_perag =
	{"xfs_perag", xfs_perag, "address", "[XFS] print xfs_perag_t table"};
extern addr_t print_xfs_perag();

PRIVATE addr_t
xfs_mount()
{
	int i, c;
	addr_t addr = 0;
	int iflag = 0;

	while ((c = getopt(argcnt, args, "hil")) != EOF) {
		switch (c) {
		case 'i':
			iflag |= 1;
			break;
		case 'l':
			iflag |= 2;
			break;
		case 'h':
			iflag |= 4;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = print_xfs_mount(getvalue(args[i]), iflag);
		}
	} else {
		THROW(usage);
	}
	return addr;
}

PRIVATE addr_t
xfs_perag()
{
	int i, c;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = print_xfs_perag(getvalue(args[i]), 0);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
