/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <asm/semaphore.h>

void
prhead_semaphore()
{
	mprintf(SPTR"  CNT SLEEP\n", "ADDR");
}

void
__print_semaphore(semp)
	struct semaphore *semp;
{
	mprintf("%4d %5d", ATOMIC_READ(semp->count), semp->waking);
}

addr_t
print_semaphore(addr)
addr_t addr;
{
	struct semaphore sem;

	memread(addr, sizeof(struct semaphore), &sem, "semaphore");
	mprintf(FPTR " ", addr);
	__print_semaphore(&sem);
	mprintf("\n");
	return ATOMIC_READ(sem.count);
}
