/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t file();
const commandtable_t command_file =
	{"file", file, "[address]", "print file table"};

addr_t inuse_filps_addr;

extern addr_t print_file();

PRIVATE addr_t
file()
{
	int i, c;
	int full = 0;
	addr_t addr;
	extern const char head_file[];

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		if (!full) mprintf(head_file);
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			if (full) mprintf(head_file);
			addr = print_file(addr, full);
		}
	} else {
		GETADDR(inuse_filps);
		memread(inuse_filps_addr, sizeof(addr), &addr, "inuse_filps");

		if (!full) mprintf(head_file);
		while (addr) {
			if (full) mprintf(head_file);
			addr = print_file(addr, full);
		}
	}
	return addr;
}
