#include "crash.h"

extern const commandtable_t
	command_address_space,
	command_bh,
	command_binfmt,
	command_blk_dev_struct,
	command_block_device,
	command_buffer_head,
	command_char_device,
	command_ext2_inode_info,
	command_fib_table,
	command_file,
	command_file_lock,
	command_files_stat,
	command_inode,
	command_kmem_cache,
	command_lv,
	command_neighbour,
	command_operations,
	command_page,
	command_pglist_data,
	command_pv,
	command_request_queue,
	command_rtable,
	command_slab,
	command_sock,
	command_socket,
	command_swap_info,
	command_tq_struct,
	command_timer_vec,
	command_usb_bus,
	command_usb_device,
	command_usb_driver,
	command_vg,
	command_vm_area_struct,
	command_vm_struct,
	command_zone;

const commandtable_t *commandtable_vers[] = {
	&command_address_space,
	&command_bh,
	&command_binfmt,
	&command_blk_dev_struct,
	&command_block_device,
	&command_buffer_head,
#if SUBLEVEL>=5
	&command_char_device,
#endif
	&command_ext2_inode_info,
	&command_fib_table,
	&command_file,
	&command_file_lock,
	&command_files_stat,
	&command_inode,
	&command_kmem_cache,
#ifdef CONFIG_BLK_DEV_LVM
	&command_lv,
#endif
	&command_neighbour,
	&command_operations,
	&command_page,
	&command_pglist_data,
#ifdef CONFIG_BLK_DEV_LVM
	&command_pv,
#endif
	&command_request_queue,
	&command_rtable,
	&command_slab,
	&command_sock,
	&command_socket,
	&command_swap_info,
	&command_tq_struct,
	&command_timer_vec,
#ifdef CONFIG_USB
	&command_usb_bus,
	&command_usb_device,
	&command_usb_driver,
#endif
#ifdef CONFIG_BLK_DEV_LVM
	&command_vg,
#endif
	&command_vm_area_struct,
	&command_vm_struct,
	&command_zone,
};
const int ncmdtable_vers = LENGTHOF(commandtable_vers);

void
vers_init()
{
	extern addr_t cache_cache_addr;
	extern addr_t init_task_addr;

	cache_cache_addr = searchaddr_bysym("cache_cache");
	init_task_addr = searchaddr_bysym("init_task_union");
}
