/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t neighbour();
const commandtable_t command_neighbour =
	{"neighbour", neighbour, "[address]", "print neighbour"};
extern void prhead_neighbour();
extern addr_t print_neighbour();

PRIVATE addr_t
neighbour()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	} else {
		prhead_neighbour();
		while (args[optind]) {
			addr = print_neighbour(getvalue(args[optind]));
			optind++;
		}
	}
	return addr;
}
