#include "crash.h"

extern const commandtable_t
	command_address_space,
	command_binfmt,
	command_block_device,
	command_buffer_head,
	command_ext2_inode,
	command_fib_table,
	command_file,
	command_file_lock,
	command_files_stat,
	command_inode,
	command_kmem_cache,
	command_namespace,
	command_neighbour,
	command_operations,
	command_page,
	command_pglist_data,
	command_request_queue,
	command_rtable,
	command_slab,
	command_sock,
	command_socket,
	command_swap_info,
	command_timer_vec,
	command_usb_bus,
	command_usb_device,
	command_usb_driver,
	command_vm_area_struct,
	command_vm_struct,
	command_zone;

const commandtable_t *commandtable_vers[] = {
	&command_address_space,
	&command_binfmt,
	&command_block_device,
	&command_buffer_head,
	&command_ext2_inode,
	&command_fib_table,
	&command_file,
	&command_file_lock,
	&command_files_stat,
	&command_inode,
	&command_kmem_cache,
	&command_namespace,
	&command_neighbour,
	&command_operations,
	&command_page,
	&command_pglist_data,
	&command_request_queue,
	&command_rtable,
	&command_slab,
	&command_sock,
	&command_socket,
	&command_swap_info,
	&command_timer_vec,
#ifdef CONFIG_USB
	&command_usb_bus,
	&command_usb_device,
	&command_usb_driver,
#endif
	&command_vm_area_struct,
	&command_vm_struct,
	&command_zone,
};
const int ncmdtable_vers = LENGTHOF(commandtable_vers);

void
vers_init()
{
	extern addr_t cache_chain_addr;
	extern addr_t init_task_addr;

	cache_chain_addr = searchaddr_bysym("cache_chain");
	init_task_addr = searchaddr_bysym("init_task");
}
