/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "crash.h"

PRIVATE const commandtable_t command_cmd = {"!cmd", NULL, NULL, NULL};

extern const commandtable_t
	command_alias,
	command_date,
	command_deftask,
	command_dentry,
	command_dmesg,
	command_dsymbol,
	command_dump,
	command_echo,
	command_file_system_type,
	command_files_struct,
	command_fs_struct,
	command_function,
	command_help,
	command_mm_struct,
	command_module,
	command_print,
	command_quit,
	command_search,
	command_semaphore,
	command_set,
	command_sizeof,
	command_super_block,
	command_sys_call_table,
	command_task_struct,
	command_vfsmount,
	command_question;

const commandtable_t *commandtable_base[] = {
	&command_cmd,			/* must be at first line */
	&command_alias,
	&command_date,
	&command_deftask,
	&command_dentry,
	&command_dmesg,
	&command_dsymbol,
	&command_dump,
	&command_echo,
	&command_file_system_type,
	&command_files_struct,
	&command_fs_struct,
	&command_function,
	&command_help,
	&command_mm_struct,
	&command_module,
	&command_print,
	&command_quit,
	&command_search,
	&command_semaphore,
	&command_set,
	&command_sizeof,
	&command_super_block,
	&command_sys_call_table,
	&command_task_struct,
	&command_vfsmount,
	&command_question,
};
const int ncmdtable_base = LENGTHOF(commandtable_base);

const char *initial_alias[] = {
	"d", "dump",
	"dh", "dump -h",
	"dd", "dump -d",
	"dw", "dump -w",
	"ls", "!ls",
	"mem_map", "page",
	"p", "task_struct",
	"sd", "request_queue *(*rscsi_disks+sizeof(*))+sizeof(*)*3+sizeof(wait_queue_head_t)",
};
int aliastable_size = sizeof(initial_alias) / sizeof(initial_alias[0]) / 2;

const char *initial_function[] = {
	"i", "if [$# <= 1]; then inode | less; else inode $*; fi",
	"f", "if [$# <= 1]; then file | less; else file $*; fi",
#if LINUXVER==25
	"traceall", "task_struct init_task; cur=$?; trace init_task; while [$cur != init_task]; do echo; task_struct $cur; next=$?; trace $cur; cur=$next; done",
#else
	"traceall", "task_struct init_task_union; cur=$?; trace init_task_union; while [$cur != init_task_union]; do echo; task_struct $cur; next=$?; trace $cur; cur=$next; done",
#endif
};
int functiontable_size = sizeof(initial_function) / sizeof(initial_function[0]) / 2;
