/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xfs_vfs();
const commandtable_t command_xfs_vfs =
	{"xfs_vfs", xfs_vfs, "[address]", "[XFS] print xfs_vfs table"};

addr_t super_blocks_addr, xfs_fs_type_addr;

extern addr_t print_xfs_vfs(), print_superblock_union();

PRIVATE addr_t
xfs_vfs()
{
	int i, c, full = 0;
	struct list_head super_blocks;
	addr_t addr = 0;
	extern void prhead_xfs_vfs();

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (super_blocks_addr == 0) {
		super_blocks_addr = searchaddr_bysym("super_blocks");
		if (super_blocks_addr == 0) {
			THROW("super_blocks not found");
		}
	}
	memread(super_blocks_addr, sizeof(super_blocks), &super_blocks,
		"super_blocks");

	if (xfs_fs_type_addr == 0) {
		xfs_fs_type_addr = searchaddr_bysym("xfs_fs_type");
		if (xfs_fs_type_addr == 0) {
			THROW("xfs_fs_type not found");
		}
	}

	prhead_xfs_vfs();

	if (argcnt > optind) {
		for (i = 1; i < argcnt; i++) {
			addr = getvalue(args[i]);
			addr = print_xfs_vfs(addr, full);
		}
	} else {
		for (addr = (addr_t)super_blocks.next; addr && addr != super_blocks_addr;) {
			addr = print_superblock_union(addr, xfs_fs_type_addr, print_xfs_vfs);
		}
	}
	return addr;
}
