/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t buffer_head();
const commandtable_t command_buffer_head =
	{"buffer_head", buffer_head, "[-f] address", "print buffer_head table\n  -f  show detail"};

addr_t hash_table_addr;
addr_t bh_hash_mask_addr;

extern addr_t print_buffer_head();

PRIVATE addr_t
buffer_head()
{
	int i, c;
	int full = 0;
	addr_t addr, hash_table;
	int bh_hash_mask;
	extern void prhead_buffer_head();

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		if (!full) prhead_buffer_head();
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			if (full) prhead_buffer_head();
			addr = print_buffer_head(addr, full);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
