/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t vfsmount();
const commandtable_t command_vfsmount =
	{"vfsmount", vfsmount, "[address]", "print vfsmount table"};

addr_t vfsmntlist_addr;

extern addr_t print_vfsmount();

PRIVATE addr_t
vfsmount()
{
	int i, c;
	addr_t addr;
	extern void prhead_vfsmount();

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	prhead_vfsmount();

	if (optind == argcnt) {
		GETADDR(vfsmntlist);
		memread(vfsmntlist_addr, sizeof(addr), &addr, "vfsmntlist");
		while (addr != vfsmntlist_addr && addr) {
			addr = print_vfsmount(addr, 1);
		}
	} else {
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			addr = print_vfsmount(addr, 0);
		}
	}
	return addr;
}
