/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t file(), files_stat();
const commandtable_t command_file =
	{"file", file, "[address]", "print file table"};
const commandtable_t command_files_stat =
	{"files_stat", files_stat, "", "print files_stat_struct"};

addr_t anon_list_addr;
addr_t files_stat_addr;

extern addr_t print_file();
extern void print_files_stat();

PRIVATE addr_t
file()
{
	int i, c;
	int full = 0;
	addr_t addr;
	extern void prhead_file();

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		if (!full) prhead_file();
		for (i = optind; i < argcnt; i++) {
			addr = getaddr(args[i]);
			if (full) prhead_file();
			addr = print_file(addr, full);
		}
	} else {
		GETADDR(anon_list);
		memread(anon_list_addr, sizeof(addr), &addr, "anon_list");

		if (!full) prhead_file();
		while (addr && anon_list_addr != addr) {
			if (full) prhead_file();
			addr = print_file(addr, full);
		}
	}
	return addr;
}

PRIVATE addr_t
files_stat()
{
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}
	GETADDR(files_stat);
	print_files_stat(files_stat_addr);
	return 0;
}
