/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t rtable();
const commandtable_t command_rtable =
	{"rtable", rtable, "[address]", "print rtable"};
extern void prhead_rtable();
extern addr_t print_rtable();
extern addr_t print_rt_hash_table();

PRIVATE addr_t fib_table();
const commandtable_t command_fib_table =
	{"fib_table", fib_table, "", "print fib_table"};
extern void prhead_fib_table();
extern addr_t print_fib_table();
addr_t main_table_addr, local_table_addr;

PRIVATE addr_t
rtable()
{
	addr_t addr;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		static addr_t rt_hash_table_addr, rt_hash_mask_addr;
		addr_t rt_hash_table;
		unsigned rt_hash_mask;

		GETADDR(rt_hash_table);
		GETADDR(rt_hash_mask);
		memread(rt_hash_table_addr, sizeof(rt_hash_table), &rt_hash_table, "rt_hash_table");
		memread(rt_hash_mask_addr, sizeof(rt_hash_mask), &rt_hash_mask, "rt_hash_mask");
		print_rt_hash_table(rt_hash_table, rt_hash_mask + 1);
	} else {
		prhead_rtable();
		while (args[optind]) {
			addr = print_rtable(getaddr(args[optind]));
			optind++;
		}
	}
	return addr;
}

addr_t
fib_table()
{
	addr_t addr;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind != argcnt)
		THROW(usage);

	GETADDR(main_table);
	mprintf("main_table\n");
	memread(main_table_addr, sizeof(addr), &addr, "main_table");
	prhead_fib_table();
	print_fib_table(addr);

	GETADDR(local_table);
	mprintf("\nlocal_table\n");
	memread(local_table_addr, sizeof(addr), &addr, "local_table");
	prhead_fib_table();
	print_fib_table(addr);

	return 0;
}
