/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/blkdev.h>

const char head_blk_dev_struct[] = "    ADDR DEV   REQ_FN    QUEUE     DATA  CURRENT\n";

void
print_blk_dev_struct(addr, n)
	int n;
	addr_t addr;
{
	struct blk_dev_struct bd;

	if (n >= 0) {
		addr += sizeof(bd) * n;
	}
	memread(addr, sizeof(bd), &bd, "blk_dev_struct");
	if (bd.queue == NULL && bd.data == NULL) {
		int i;
		char *p;
		for (i = 0, p = (char *)&bd; i < sizeof(&bd) && *p == 0; i++, p++)
			;
		if (i == sizeof(&bd))
			return;
	}
		
	mprintf(FPTR " ", addr);
	if (n >= 0) {
		mprintf("%3d", n);
	} else {
		mprintf("  -");
	}
	mprintf(" %8lx %8lx %8lx %8lx\n", bd.request_fn, bd.queue, bd.data, bd.current_request);
}

addr_t
print_request(addr)
	addr_t addr;
{
	struct request req;

	memread(addr, sizeof(req), &req, "request");
	return (addr_t)req.next;
}
