/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/param.h>
#include <linux/wait.h>
#include <linux/socket.h>
#include <linux/sunrpc/svc.h>
#include <linux/sunrpc/sched.h>
#include <linux/lockd/lockd.h>

void
prhead_nlm_rqst()
{
	mprintf(SPTR" FLAG "SPTR" "SPTR" "SPTR" OWNER\n",
		"ADDR", "HOST", "CALLER", "FL");
}

addr_t
print_nlm_rqst(addr, full)
	addr_t addr;
	int full;
{
	struct nlm_rqst rqst;

	memread(addr, sizeof(rqst), &rqst, "nlm_rqst");
	mprintf(FPTR " ", addr);

	mprintf("%4x " FPTR " ", rqst.a_flags, rqst.a_host);
	mprintf(FPTR " " FPTR " ", rqst.a_args.lock.caller,
		addr + OFFSET(struct nlm_rqst, a_args.lock.fl));

	mprintstr(rqst.a_owner, sizeof(rqst.a_owner));
	mprintf("\n");
	return 0;
}

void
prhead_nlm_file()
{
	mprintf(SPTR" "SPTR" "SPTR" "SPTR" "SPTR" LOCKS COUNT  HASH\n",
		"ADDR", "DENTRY", "F_OP", "SHARES", "BLOCKS");
}

addr_t
print_nlm_file(addr, full)
	addr_t addr;
	int full;
{
	struct nlm_file file;

	memread(addr, sizeof(file), &file, "nlm_file");
	mprintf(FPTR " ", addr);

	mprintf(FPTR " " FPTR " " FPTR " " FPTR " ",
		file.f_file.f_dentry, file.f_file.f_op,
		file.f_shares, file.f_blocks);
	mprintf("%5x %5x %5x\n", file.f_locks, file.f_count, file.f_hash);
	return (addr_t)file.f_next;
}

void
prhead_nlm_block()
{
	mprintf(SPTR" "SPTR" "SPTR" "SPTR"     WHEN ID QGID "SPTR" OWNER\n",
		"ADDR", "CALL", "DAEMON", "HOST", "FILE");
}

addr_t
print_nlm_block(addr, full)
	addr_t addr;
	int full;
{
	struct nlm_block block;

	memread(addr, sizeof(block), &block, "nlm_block");
	mprintf(FPTR " ", addr);
	mprintf(FPTR " " FPTR " " FPTR " ",
		addr + OFFSET(struct nlm_block, b_call),
		block.b_daemon, block.b_host);
	mprintf("%8lx %2x %x%x%x%x ",
		block.b_when, block.b_id,
		block.b_queued,
		block.b_granted,
		block.b_incall,
		block.b_done);
	mprintf(FPTR " ", block.b_file);
	mprintstr(block.b_call.a_owner, sizeof(block.b_call.a_owner));
	mprintf("\n");

	return (addr_t)block.b_next;
}
