/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/namespace.h>
#include <linux/mount.h>

void
prhead_namespace()
{
	mprintf(SPTR" CNT "SPTR " "SPTR"\n", "ADDR", "ROOT", "MNT_LIST");
}

addr_t
print_namespace(addr)
	addr_t addr;
{
	struct namespace ns;

	if (addr == 0) {
		struct task_struct ts;

		memread(init_task_addr, sizeof(struct task_struct), &ts, "task_struct");
		addr = (addr_t)ts.namespace;
	}

	memread(addr, sizeof(struct namespace), &ns, "namespace");
	mprintf(FPTR " %3x " FPTR " ", addr, ATOMIC_READ(ns.count), ns.root);
	if (ns.list.next && (addr_t)ns.list.next != addr + OFFSET(struct namespace, list)) {
		mprintf(FPTR, (addr_t)ns.list.next - OFFSET(struct vfsmount, mnt_list));
	} else {
		mprintf(SPTR, "-");
	}
	mprintf("\n");
	return (addr_t)ns.list.next;
}
