/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t namespace();
const commandtable_t command_namespace =
	{"namespace", namespace, "address", "print namespace table"};

extern void prhead_namespace();
extern addr_t print_namespace();

PRIVATE addr_t
namespace()
{
	int c;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	prhead_namespace();
	if (argcnt == optind) {
		addr = print_namespace(0);
	} else {
		while (args[optind]) {
			addr = print_namespace(getvalue(args[optind]));
			optind++;
		}
	}
	return addr;
}
