/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xlog();
const commandtable_t command_xlog =
	{"xlog", xlog, "address", "[XFS] print xlog_t table"};
extern addr_t print_xlog();

PRIVATE addr_t xlog_ticket();
const commandtable_t command_xlog_ticket =
	{"xlog_ticket", xlog_ticket, "[-a] address", "[XFS] print xlog_ticket_t table\n  -a  follow list"};
extern void prhead_xlog_ticket();
extern addr_t print_xlog_ticket();

PRIVATE addr_t xlog_in_core();
const commandtable_t command_xlog_in_core =
	{"xlog_in_core", xlog_in_core, "[-a] address", "[XFS] print xlog_in_core_t table\n  -a  follow list"};
extern void prhead_xlog_in_core();
extern addr_t print_xlog_in_core();

PRIVATE addr_t
xlog()
{
	int i, c;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			addr = print_xlog(addr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}

PRIVATE addr_t
xlog_ticket()
{
	int i, c;
	addr_t addr = 0;
	int aflag = 0;

	while ((c = getopt(argcnt, args, "a")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		prhead_xlog_ticket();
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			do {
				addr = print_xlog_ticket(addr);
			} while (aflag && addr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}

PRIVATE addr_t
xlog_in_core()
{
	int i, c;
	addr_t addr = 0, saddr;
	int aflag = 0;

	while ((c = getopt(argcnt, args, "a")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		prhead_xlog_in_core();
		for (i = optind; i < argcnt; i++) {
			addr = saddr = getvalue(args[i]);
			do {
				addr = print_xlog_in_core(addr);
			} while (aflag && addr && saddr != addr);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
