/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/module.h>

void
prhead_module()
{
	mprintf(SPTR" "SPTR" "SPTR" UCNT NSYMS NDEPS  NAME         FLAGS\n",
		"ADDR", "INIT", "CLEANUP");
}

addr_t
print_module(addr, full)
addr_t addr;
int full;
{
	struct module m;
	char buf[32];
	static const struct bitname mflags[] = {
		{ MOD_RUNNING,		"run" },
		{ MOD_DELETED,		"deleted" },
		{ MOD_AUTOCLEAN,	"autoclean" },
		{ MOD_VISITED,		"vis" },
		{ MOD_USED_ONCE,	"u_once" },
		{ MOD_JUST_FREED,	"just_freed" },
		{ MOD_INITIALIZING,	"initializing" },
		{ 0,			0 }
	};

	memread(addr, sizeof(m), &m, "module");
	mprintf(FPTR " ", addr);
	mprintf(FPTR " " FPTR, m.init, m.cleanup);
	mprintf(" %4x %5x %5x", m.uc.usecount.counter, m.nsyms, m.ndeps);
	memread((addr_t)m.name, sizeof(buf), buf, "module name");
	mprintf("  %-12s", buf);
	mprintbit(mflags, m.flags);
	if (m.flags == 0) {
		mprintf(" uninitialized\n");
	} else {
		mprintf("\n");
	}
	return (addr_t)m.next;
}

addr_t
getmsyms(addr)
	addr_t addr;
{
	int i;
	struct module m;
	struct module_symbol msym;
	char buf[256];

	memread(addr, sizeof(m), &m, "module");
	if (m.init == 0)
		return 0;	/* maybe kernel_module */

	for (i = 0; i < m.nsyms; i++) {
		memread((addr_t)m.syms + sizeof(msym) * i, sizeof(msym), &msym, "module_symbol");
		if (msym.value == 0 || msym.name == 0)
			continue;
		memread((addr_t)msym.name, sizeof(buf), buf, "symbol name");
		addsym(buf, msym.value, 0);
	}
	return (addr_t)m.next;
}
