/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/lvm.h>

#include "printdev.h"

extern addr_t vg_addr;
extern addr_t print_lv(), print_pv();

void
prhead_vg()
{
	mprintf(SPTR" VG# L M CUR OPN P M CUR ACT VGDA  SIZE TOTAL ALLOC NAME FLAG\n",
		"ADDR");
}

addr_t
print_vg(addr, full)
addr_t addr;
int full;
{
	int i;
	vg_t vg;
	static const struct bitname vgstatus[] = {
		{ VG_ACTIVE,	"active" },
		{ VG_EXPORTED,	"exported" },
		{ VG_EXTENDABLE,"extendable" },
		{ 0,		NULL }
	};
	static const struct bitname vgaccess[] = {
		{ VG_READ,	"read" },
		{ VG_WRITE,	"write" },
		{ VG_CLUSTERED, "clustered" },
		{ VG_SHARED,	"shared" },
		{ 0,		NULL }
	};

	if (addr >= 0 && addr < ABS_MAX_VG) {
		memread(vg_addr + sizeof(addr) * addr, sizeof(addr), &addr, "vg");
		if (addr == 0) {
			return -1;
		}
	}

	if (full) prhead_vg();

	memread(addr, sizeof(vg), &vg, "vg");
	mprintf(FPTR " ", addr);

	mprintf("%3x %3x %3x %3x %3x %3x %3x",
		vg.vg_number, vg.lv_max, vg.lv_cur, vg.lv_open,
		vg.pv_max, vg.pv_cur, vg.pv_act);
	mprintf(" %4x %5x %5x %5x ",
		vg.vgda, vg.pe_size, vg.pe_total, vg.pe_allocated);
	mprintstr(vg.vg_name, NAME_LEN);
	mprintbit(vgaccess, vg.vg_access);
	mprintbit(vgstatus, vg.vg_status);
	mprintf("\n");
	if (full) {
		mprintf("PV:\n");
		for (i = 0; i <= ABS_MAX_PV; i++) {
			if (vg.pv[i]) {
				mprintf("%2x ", i);
				print_pv(vg.pv[i], 2);
			}
		}
		mprintf("LV:\n");
		for (i = 0; i <= ABS_MAX_LV; i++) {
			if (vg.lv[i]) {
				mprintf("%2x ", i);
				print_lv(vg.lv[i], 2);
			}
		}
		mprintf("\n");
	}
	return 0;
}

addr_t
print_pv(addr, full)
addr_t addr;
int full;
{
	pv_t pv;

	memread(addr, sizeof(pv), &pv, "pv");
	if (full == 2) {
		mprintf(FPTR " ", addr);
		mprint_kdev_t(pv.pv_dev);
		mprintf(" %8x ", pv.pv_size);
		mprintstr(pv.pv_name, NAME_LEN);
		mprintf("\n");
		return 0;
	}

	mprintf("id:  %02x%02x\n", pv.id[0], pv.id[1]);
	mprintf("version:  %04x\n", pv.version);
	mprintf("pv_name:  "); mprintstr(pv.pv_name, NAME_LEN); mprintf("\n");
	mprintf("vg_name:  "); mprintstr(pv.vg_name, NAME_LEN); mprintf("\n");
	mprintf("system_id:  "); mprintstr(pv.system_id, NAME_LEN); mprintf("\n");
	mprintf("pv_dev: %04x\n", pv.pv_dev);
	mprintf("pv_number: %x\n", pv.pv_number);
	mprintf("pv_status: %x\n", pv.pv_status);
	mprintf("pv_allocatable: %x\n", pv.pv_allocatable);
	mprintf("pv_size: %x\n", pv.pv_size);
	mprintf("lv_cur: %x\n", pv.lv_cur);
	mprintf("pe_size: %x\n", pv.pe_size);
	mprintf("pe_total: %x\n", pv.pe_total);
	mprintf("pe_allocated: %x\n", pv.pe_allocated);
	mprintf("pe_stale: %x\n", pv.pe_stale);
	mprintf("pe: %08lx\n", pv.pe);
#if SUBLEVEL>=15
	mprintf("bd: " FPTR "\n", pv.bd);
#else
	mprintf("inode:  " FPTR "\n", pv.inode);
#endif
	mprintf("pv_uuid:  "); mprintstr(pv.pv_uuid, UUID_LEN + 1); mprintf("\n");
	return 0;
}

addr_t
print_lv(addr, full)
addr_t addr;
int full;
{
	lv_t lv;

	memread(addr, sizeof(lv), &lv, "lv");
	if (full == 2) {
		mprintf(FPTR " ", addr);
		mprintf(" %2x %2x %2x", lv.lv_access, lv.lv_status, lv.lv_open);
		mprint_kdev_t(lv.lv_dev);
		mprintf(" %2x ", lv.lv_number);
		mprintf("%8x ", lv.lv_size);
		mprintstr(lv.lv_name, NAME_LEN);
		mprintf("\n");
		return 0;
	}

	mprintf("lv_name:   "); mprintstr(lv.lv_name, NAME_LEN); mprintf("\n");
	mprintf("vg_name:   "); mprintstr(lv.vg_name, NAME_LEN); mprintf("\n");
	mprintf("access:    %x\n", lv.lv_access);
	mprintf("status:    %x\n", lv.lv_status);
	mprintf("open:      %x\n", lv.lv_open);
	mprintf("dev:       %x\n", lv.lv_dev);
	mprintf("number:    %x\n", lv.lv_number);
	mprintf("size:      %x\n", lv.lv_size);
	mprintf("stripes:   %x\n", lv.lv_stripes);
	mprintf("stripesize %x\n", lv.lv_stripesize);
	mprintf("chunk_size %x\n", lv.lv_chunk_size);
	mprintf("current_pe: " FPTR "\n", lv.lv_current_pe);
	mprintf("vg:         " FPTR "\n", lv.vg);
	return 0;
}
