/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/device.h>

void
prhead_kobject()
{
	mprintf("REF "SPTR" "SPTR" "SPTR" "SPTR" NAME\n",
		"PARENT", "KSET", "KTYPE", "DENTRY");
}

addr_t
mprint_kobject(ko)
	struct kobject *ko;
{
	mprintf("%3x " FPTR " " FPTR " " FPTR " " FPTR " ",
		ATOMIC_READ(ko->refcount),
		ko->parent, ko->kset, ko->ktype, ko->dentry);
	mprintstr(ko->name, sizeof(ko->name));
	mprintf("\n");
	return (addr_t)ko->entry.next;
}

void
prhead_device()
{
	mprintf(SPTR" LIST "SPTR" "SPTR" "SPTR" POWER DETCH "SPTR" BUS_ID\n",
		"ADDR", "PARENT", "BUS", "DRIVER", "RELEASE");
}

addr_t
print_device(addr, full)
	addr_t addr;
	int full;
{
	struct device dev;

	memread(addr, sizeof(dev), &dev, "device");
	mprintf(FPTR " ", addr);
#define IS_LISTED(list) ((addr_t)dev.list.next != addr + OFFSET(struct device,list))
	mprintf("%c%c%c%c ",
		IS_LISTED(node)       ? 'N': '-',
		IS_LISTED(bus_list)   ? 'B': '-',
		IS_LISTED(driver_list)? 'D': '-',
		IS_LISTED(children)   ? 'C': '-');
	mprintf(FPTR " ", dev.parent);
	mprintf(FPTR " ", dev.bus);
	mprintf(FPTR " ", dev.driver);
	mprintf("%5x ", dev.power_state);
	mprintf("%5x ", dev.detach_state);
	mprintf(FPTR " ", dev.release);
	mprintstr(dev.bus_id, sizeof(dev.bus_id));
	mprintf("\n");
	if (full) {
		prhead_kobject();
		mprint_kobject(&dev.kobj);
	}
	return (addr_t)dev.node.next;
}
