/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/mm.h>
#include <linux/swap.h>

#include "printdev.h"

void
prhead_swap_info()
{
	mprintf(SPTR " " SPTR " " SPTR " NRX " SPTR " PRIO PAGES      MAX FLAGS\n",
		"ADDR", "FILE", "BDEV", "MAP");
}

addr_t
print_swap_info(n, full)
	addr_t n;
	int full;
{
	addr_t addr;
	struct swap_info_struct si;
	extern addr_t swap_info_addr;

	if (n == -1) {
		struct swap_list_t sl;
		extern addr_t swap_list_addr;

		memread(swap_list_addr, sizeof(sl), &sl, "swap_list");
		if (sl.head < 0 || sl.head >= MAX_SWAPFILES)
			return -1;
		addr = swap_info_addr + sizeof(si) * sl.head;
	} else if (n >= 0 && n < MAX_SWAPFILES) {
		addr = swap_info_addr + sizeof(si) * n;
	} else {
		addr = n;
	}

	mprintf(FPTR " ", addr);
	if (addr == 0) {
		mprintf("\n");
		return 0;
	}
	memread(addr, sizeof(si), &si, "swap_info");

	mprintf(FPTR " " FPTR " %3x " FPTR " ",
		si.swap_file, si.bdev, si.nr_extents, si.swap_map);
	mprintf("%4d %5x %8lx", si.prio, si.pages, si.max);
	mprintf("%s%s\n", (si.flags & SWP_USED)? " used": "",
			  (si.flags & SWP_WRITEOK) == SWP_WRITEOK? " writeok": "");
	return si.next;
}
