/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp.daemon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ApplicationProperties {
    private static final String PREFIX = "org.jent.checksmtp";
    private static final String SMTP_SERVER_HOST = "org.jent.checksmtp.serverHost";
    private static final String SMTP_SERVER_PORT = "org.jent.checksmtp.serverPort";
    private static final String SMTP_PORT = "org.jent.checksmtp.port";
    private static final String LDAP_PREFIX = "org.jent.checksmtp.ldap";
    private static final String LDAP_PROVIDER_URL = "org.jent.checksmtp.ldap.providerUrl";
    private static final String LDAP_ROOT = "org.jent.checksmtp.ldap.root";
    private static final String LDAP_IS_SJIS = "org.jent.checksmtp.ldap.isSjis";
    private static final String LDAP_IS_ATTRIBUTES = "org.jent.checksmtp.ldap.attributes";
    private static final String PROPERTIES_FILENAME = ".checksmtp.properties";
    private static Properties applicationProperties = new Properties();
    private static String fileName = ".checksmtp.properties";

    private ApplicationProperties() {
    }

    public static void save() {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            applicationProperties.store(fos, "Appliction Properties");
            fos.close();
        }
        catch (IOException e) {
            System.err.println(String.valueOf(fileName) + "was occrred save error.");
            e.printStackTrace();
        }
    }

    public static String getSmtpServerHost() {
        return applicationProperties.getProperty(SMTP_SERVER_HOST, "mail");
    }

    public static void setSmtpServerHost(String obj) {
        applicationProperties.setProperty(SMTP_SERVER_HOST, obj);
    }

    public static int getSmtpServerPort() {
        return Integer.parseInt(applicationProperties.getProperty(SMTP_SERVER_PORT, "25"));
    }

    public static void setSmtpServerPort(int port) {
        applicationProperties.setProperty(SMTP_SERVER_PORT, new Integer(port).toString());
    }

    public static int getSmtpPort() {
        return Integer.parseInt(applicationProperties.getProperty(SMTP_PORT, "8725"));
    }

    public static void setSmtpPort(int port) {
        applicationProperties.setProperty(SMTP_PORT, new Integer(port).toString());
    }

    public static String getLdapProviderURL() {
        return applicationProperties.getProperty(LDAP_PROVIDER_URL, "ldap://localhost:389");
    }

    public static void setLdapProviderURL(String obj) {
        applicationProperties.setProperty(LDAP_PROVIDER_URL, obj);
    }

    public static String getLdapRoot() {
        return applicationProperties.getProperty(LDAP_ROOT, "C=JP");
    }

    public static void setLdapRoot(String obj) {
        applicationProperties.setProperty(LDAP_ROOT, obj);
    }

    public static boolean getLdapIsSjis() {
        return new Boolean(applicationProperties.getProperty(LDAP_IS_SJIS));
    }

    public static void setLdapRoot(boolean obj) {
        applicationProperties.setProperty(LDAP_IS_SJIS, Boolean.toString(obj));
    }

    public static boolean getLdap() {
        String str = applicationProperties.getProperty(LDAP_PREFIX);
        Boolean flg = new Boolean(str);
        return flg;
    }

    public static void setLdap(boolean obj) {
        applicationProperties.setProperty(LDAP_PREFIX, Boolean.toString(obj));
    }

    public static String getLdapAttributes() {
        return applicationProperties.getProperty(LDAP_IS_ATTRIBUTES, "cn");
    }

    public static void setLdapAttributes(String obj) {
        applicationProperties.setProperty(LDAP_IS_ATTRIBUTES, obj);
    }

    static {
        try {
            fileName = String.valueOf(System.getProperty("user.home")) + File.separator + PROPERTIES_FILENAME;
            FileInputStream is = new FileInputStream(fileName);
            applicationProperties.load(is);
            is.close();
        }
        catch (IOException e) {
            System.err.println("No checksmtp.properties in " + fileName);
        }
    }
}

