﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace mdc5linker
{
    public partial class imageselecter : Form
    {
        struct memory_name{
            public int Capacity{
                get; set;
            }
            public string Name{
                get; set;
            }
        }
        readonly Interface.Konfig m_config;
        readonly Dictionary<string, int> m_romcapacity_dictionary;
        readonly Dictionary<string, imagestream.W_Ram.board> m_ramcapacity_dictionary;
        MenuItem[] rom_submenu_make(int config_romcapacity, out Dictionary<string, int> d)
        {
            string [] capacity = {
                "&Auto", "&512Kbit", 
                "&1Mbit", "&2Mbit", "&4Mbit", "&8Mbit"
            };
            MenuItem [] item = new MenuItem[capacity.Length];
            d = new Dictionary<string,int>();
            for(int i = 0; i < capacity.Length; i++){
                item[i] = new MenuItem(capacity[i], new EventHandler(romcapacity_Click));
                item[i].RadioCheck = true;
            }
            d[capacity[0]] = 0;
            int found_index = 0;
            int val = 0x10000;
            for(int i = 1; i < capacity.Length; i++){
                d[capacity[i]] = val;
                if(config_romcapacity == val){
                    found_index = i;
                }
                val *= 2;
            }
            item[found_index].Checked = true;
            return item;
        }
        MenuItem[] ram_submenu_make(imagestream.W_Ram.board config_ramcapacity, out Dictionary<string, imagestream.W_Ram.board> d)
        {
            string [] capacity = {
                "ELROM", "EKROM/ 6264", "EWROM/ 62256",
                "ETROM/ 6264+6264", "ETROM/ 6264+62256", "ETROM/ 62256+62556"
            };
            imagestream.W_Ram.board[] tag = {
                imagestream.W_Ram.board.ELROM, imagestream.W_Ram.board.EKROM,
                imagestream.W_Ram.board.EWROM,
                imagestream.W_Ram.board.ETROM_6264_6264, imagestream.W_Ram.board.ETROM_6264_62256,
                imagestream.W_Ram.board.ETROM_62256_62256
            };
            MenuItem [] item = new MenuItem[capacity.Length];
            d = new Dictionary<string,imagestream.W_Ram.board>();
            for(int i = 0; i < capacity.Length; i++){
                item[i] = new MenuItem(capacity[i], new EventHandler(ramcapacity_Click));
                item[i].RadioCheck = true;
            }
            int found_index = 0;
            for(int i = 0; i < capacity.Length; i++){
                d[capacity[i]] = tag[i];
                if(config_ramcapacity == tag[i]){
                    found_index = i;
                }
            }
            item[found_index].Checked = true;
            return item;
        }
        MainMenu main_menu_make(
            Interface.Konfig config,
            out Dictionary<string, int> d, out Dictionary<string, imagestream.W_Ram.board> e
        ){
            //file
            MenuItem file_rescan = new MenuItem("&Rescan", new EventHandler(list_reset));
            MenuItem file_hashlist = new MenuItem("&Hashlist output", new EventHandler(hashlist_output));
            MenuItem file_filelist = new MenuItem("&Filelist output", new EventHandler(filelist_output));
            MenuItem file_exit = new MenuItem("E&xit", new EventHandler(to_Dispose));
            MenuItem file = new MenuItem("&File", new MenuItem[]{file_rescan, file_hashlist, file_filelist, file_exit});
            //option
            MenuItem option_path = new MenuItem("&Config Path", new EventHandler(path_configuration));
            MenuItem option_romname_auto = new MenuItem("ROM name &auto attach", new EventHandler(romname_auto_change));
            option_romname_auto.Checked = config.RomnameAutoattach;
            MenuItem option_patchlog_show = new MenuItem("&Patchlog show", new EventHandler(patchlog_show_change));
            option_patchlog_show.Checked= config.PatchlogShow;
            MenuItem option = new MenuItem("&Option", new MenuItem[]{option_path, option_romname_auto, option_patchlog_show});
            //rom capacity
            MenuItem rom_capacity = new MenuItem("PRG (ROM)", rom_submenu_make(config.RomCapacity, out d));
            MenuItem ram_capacity = new MenuItem("W-RAM", ram_submenu_make(config.RamCapacity, out e));
            MenuItem memory = new MenuItem("&Memory capcity", new MenuItem[]{rom_capacity, ram_capacity});
            //help
            MenuItem help_keyassign = new MenuItem("&Key Assign", new EventHandler(show_keyassign));
            MenuItem help_me = new MenuItem("Help me", new EventHandler(show_helpme));
            MenuItem help = new MenuItem("&Help", new MenuItem[]{help_keyassign, help_me});
            return new MainMenu(new MenuItem[]{file, option, memory, help});
        }
        public imageselecter(Interface.Konfig c)
        {
            m_config = c;
            InitializeComponent();
            candidate.KeyPress += new KeyPressEventHandler(this.candidate_KeyPress);
            candidate.MouseDown += new MouseEventHandler(candidate_RightClick);
            candidate.DoubleClick += new EventHandler(this.candidate_DoubleClick);
            candidate.SelectedIndexChanged += new EventHandler(this.candidate_SelectedIndexChanged);
            selected_image.KeyDown += new KeyEventHandler(this.selected_image_KeyDown);
            selected_image.SelectedIndexChanged += new EventHandler(this.candidate_SelectedIndexChanged);
            this.MaximizeBox = false;
            this.DesktopLocation = c.WindowPostion;
            this.Menu = main_menu_make(m_config, out m_romcapacity_dictionary, out m_ramcapacity_dictionary);
            this.check_bin.Checked = m_config.OutputBin;
            this.check_nes.Checked = m_config.OutputNes;
            for_candidate.Text = "変換可能イメージ";
            for_selectedimage.Text = "選択されたイメージ";
            log.Text = ToMain.VERSION;
            log.Font = new Font(c.LogFont, log.Font.Size);
            scriptInfomation.Font = new Font(c.LogFont, log.Font.Size);
            list_reset(this, null);
        }
        public void list_reset(object sender, EventArgs e)
        {
            candidate.Reset();
            selected_image.Reset();
            scriptInfomation.Reset();
            output_name.Text = "";
            if(e != null){
                log.Text = "file rescan OK";
            }
            Interface.Scanner s = new Interface.Scanner();
            log.Subscribe(s);
            if(s.ScriptFind(m_config.PathGet("diskscript.in")) == true){
                mdc5.Script [] script_rom, script_disk;
                if(s.GameImageFind(new imagefile.Fds(), m_config.PathGet("diskimage.in"), false, out script_disk) == true){
                    candidate.ScriptAdd(script_disk);
                }
                if(s.GameImageFind(new imagefile.Nes(), m_config.PathGet("romimage.in"), false, out script_rom) == true){
                    candidate.ScriptAdd(script_rom);
                }
                candidate.ScriptOrder(m_config.ListOrder);
            }
        }
        void dispose()
        {
            m_config.WindowPostion = this.DesktopLocation;
            m_config.OutputBin = this.check_bin.Checked;
            m_config.OutputNes = this.check_nes.Checked;
            m_config.FileSave();
        }

        private void candidate_KeyPress(object sender, EventArgs e)
        {
            KeyPressEventArgs key = (KeyPressEventArgs) e;
            switch(key.KeyChar){
                case '\r':
                    selected_image_add(sender);
                    break;
                case ' ':
                    m_config.ListOrderToggle();
                    candidate.ScriptOrder(m_config.ListOrder);
                    break;
            }

        }
        void candidate_RightClick(object sender, EventArgs e)
        {
            MouseEventArgs m = (MouseEventArgs) e;
            if(m.Button == MouseButtons.Right){
                m_config.ListOrderToggle();
                candidate.ScriptOrder(m_config.ListOrder);
            }
        }
        private void candidate_DoubleClick(object sender, EventArgs e)
        {
            //MouseEventArgs mouse = (MouseEventArgs) e;
            selected_image_add(sender);
        }

        private void candidate_SelectedIndexChanged(object sender, EventArgs e)
        {
            GuiList c = (GuiList) sender;
            c.ItemChanged();
        }
        private void selected_image_add(object sender)
        {
            Candinate c = (Candinate) sender;
            if(c.SelectedIndex != -1){
                mdc5.Script sc = candidate.ScriptGet(c.SelectedIndex);
                selected_image.ScriptAdd(sc);
                if(m_config.RomnameAutoattach == true){
                    output_name.Text = selected_image.OutputNameGet();
                }
            }
            if(selected_image.Count != 0){
                link_button.Enabled = true;
            }
        }

        private void selected_image_KeyDown(object sender, EventArgs e)
        {
            if(selected_image.ToKeyDown((KeyEventArgs) e) == true){
                if(m_config.RomnameAutoattach == true){
                    output_name.Text = selected_image.OutputNameGet();
                }
            }
            if (selected_image.Count == 0){
                link_button.Enabled = false;
            }
        }

        private void path_configuration(object sender, EventArgs e)
        {
            if(m_config.PathConfigutation() == true){
                this.list_reset(sender, null);
            }
        }
        bool menu_checked_toggle(object sender, EventArgs e)
        {
            MenuItem m = (MenuItem) sender;
            if(m.Checked == true){
                m.Checked = false;
            }else{
                m.Checked = true;
            }
            return m.Checked;
        }
        void romname_auto_change(object sender, EventArgs e)
        {
            m_config.RomnameAutoattach = menu_checked_toggle(sender, e);

        }
        void patchlog_show_change(object sender, EventArgs e)
        {
            m_config.PatchlogShow = menu_checked_toggle(sender, e);

        }
        private void hashlist_output(object sender, EventArgs e)
        {
            Interface.Scanner s = new Interface.Scanner();
            log.Subscribe(s);
            s.HashlistFileOut(
                m_config.PathGet("diskimage.in"), m_config.PathGet("romimage.in"), 
                m_config.PathGet("diskscript.in") + "/hashlist.txt"
            );
        }
        private void filelist_output(object sender, EventArgs e)
        {
            Interface.Scanner s = new Interface.Scanner();
            log.Subscribe(s);
            s.FilesystemlistFileOut(
                m_config.PathGet("diskimage.in"), 
                m_config.PathGet("diskimage.in") + "/filelist.txt"
            );
        }

        string memorycapacity_Click(MenuItem m)
        {
            for(int i = 0; i < m.Parent.MenuItems.Count; i++){
                m.Parent.MenuItems[i].Checked = false;
            }
            m.Checked = true;
            return m.Text;
        }
        void romcapacity_Click(object sender, EventArgs e)
        {
            string t = memorycapacity_Click((MenuItem) sender);
            m_config.RomCapacity = m_romcapacity_dictionary[t];
        }
        void ramcapacity_Click(object sender, EventArgs e)
        {
            string t = memorycapacity_Click((MenuItem) sender);
            m_config.RamCapacity = m_ramcapacity_dictionary[t];
        }
        void show_keyassign(object sender, EventArgs e)
        {
            log.Append("left list:");
            log.Append("\t[Enter] append to right list");
            log.Append("\t[Space] change left list order");
            log.Append("right list:");
            log.Append("\t[Delete] delete");
            log.Append("\t[Shift+Up] or [Shift+Down] change list order");
        }
        void show_helpme(object sender, EventArgs e)
        {
            log.Append("たすケて....");
        }
        private void to_Dispose(object sender, EventArgs e)
        {
            this.Dispose(true);
        }
        private void link_button_Click(object sender, EventArgs e)
        {
            link_button.Enabled = false;
            if(output_name.Text == ""){
                output_name.Text = "mdc5";
            }
            mdc5.GameImage m = new mdc5.GameImage();
            log.Subscribe(m);
            m_config.OutputBin = check_bin.Checked;
            m_config.OutputNes = check_nes.Checked;
            m.BatchLink(
                    m_config, selected_image.ScriptGet(),
                    output_name.Text, true, m_config.PatchlogShow
            );
            link_button.Enabled = true;
        }
    }
}
