using System;
using System.Diagnostics;
using System.Collections.Generic;
using hardware;
namespace imagestream{
	class Manage{
		const string m_sigunature = "mdc5 0.03";
		public const int ROM_CAPACITY_AUTO = 0;
		imagefile.GameImage [] m_image;
		readonly int m_cpu_rom_capacity, m_ppu_ram_capacity;
		int m_blockuse;//block is alignmented page area
		int m_streamuse;//stream does not have alignment
		readonly W_Ram m_workram;
		public Manage(int cpu_rom_capacity, int ppu_ram_capacity, W_Ram.board w_ram_board)
		{
			m_cpu_rom_capacity = cpu_rom_capacity;
			m_ppu_ram_capacity = ppu_ram_capacity;
			m_workram = new W_Ram(w_ram_board);
		}
		public void GameimageSet(imagefile.GameImage [] g)
		{
			m_image = g;
		}
		bool savedata_search(imagefile.GameImage [] image, W_Ram workram)
		{
			foreach(imagefile.GameImage t in image){
				if(t.SavedataSearch(workram) == false){
					return false;
				}
			}
			return true;
		}
		void romsize_ok(int usebyte, int rombyte, List<string>log)
		{
			string hoe = String.Format(
				"used 0x{0:x5}/0x{1:x5} byte", usebyte, rombyte
			);
			log.Add(hoe);
		}
		bool output_romsize_calc(imagefile.GameImage [] image, W_Ram workram, out int romsize, out int blockuse, out int streamuse, List<string> log)
		{
			blockuse = 0;
			streamuse = 0;
			foreach(imagefile.GameImage t in image){
				int blocksize, streamsize;
				if(t.StreamMake(workram, out blocksize, out streamsize) == false){
					romsize = 0;
					return false;
				}
				{
					int blockbyte = blocksize * mmc5.PAGESIZE;
					string hoe = String.Format(
						"{0} 0x{1:x5} byte {2:P}", 
						t.Code, blockbyte + streamsize,
						(double)(blockbyte + streamsize) / (double)t.RawByte()
					);
					log.Add(hoe);
				}
				blockuse += blocksize;
				streamuse += streamsize;
			}
			romsize = m_cpu_rom_capacity;
			int usebyte = streamuse + (blockuse + 2) * mmc5.PAGESIZE; //+2 is bios and managearea
			if(m_cpu_rom_capacity == ROM_CAPACITY_AUTO){
				romsize = 0x8000;
				while(romsize <= mmc5.CPU_ROMSIZE_MAX){
					if(usebyte < romsize){
						romsize_ok(usebyte, romsize, log);
						return true;
					}
					romsize *= 2;
				}
			}else if(usebyte < romsize){
				romsize_ok(usebyte, romsize, log);
				return true;
			}else{
				string hoe = String.Format(
					"used 0x{0:x5}/xxxxx byte", usebyte
				);
				log.Add(hoe);
			}
			return false;
		}
		void rom_allocate(imagefile.GameImage [] image, int block_offset, int stream_offset)
		{
			foreach(imagefile.GameImage t in image){
				t.RomBlockAllocate(ref block_offset);
			}
			foreach(imagefile.GameImage t in image){
				t.RomStreamAllocate(ref stream_offset);
			}
		}
		byte [] manage_make(imagefile.GameImage [] image, W_Ram workram)
		{
			List<byte> manage = new List<byte>();
			foreach(char t in m_sigunature.ToCharArray()){
				manage.Add((byte) t);
			}
			for(int i = m_sigunature.Length; i < 0x0e; i++){
				manage.Add(0xff);
			}
			workram.DiskPagenumAdd(manage);
			manage.Add((byte) image.Length);
			//image pointer array set
			Queue<byte[]> image_config = new Queue<byte[]>();
			int offset = 0xc00f + 1 + image.Length * 2;
			BgString bg = new BgString();
			foreach(imagefile.GameImage t in image){
				byte[] config = t.ManageMake(workram, offset, bg);
				m6502.word_add(manage, offset);
				offset += config.Length;
				image_config.Enqueue(config);
			}
			//image data copy
			while(image_config.Count != 0){
				foreach(byte t in image_config.Dequeue()){
					manage.Add(t);
				}
			}
			Debug.Assert(manage.Count < mdc5.Bios.MANAGE_SIZE);
			for(int i = manage.Count; i < mdc5.Bios.MANAGE_SIZE; i++){
				manage.Add(0xff);
			}
			return manage.ToArray();
		}
		byte [] game_make(imagefile.GameImage [] image, int size)
		{
			byte [] game = new byte[size];
			int offset = 0;
			List<imagefile.GameImage> q = new List<imagefile.GameImage>(image);
			int prev_offset = -1;
			while(q.Count != 0){
				int i;
				for(i = 0; i < q.Count; i++){
					bool found_block = q[i].RomBlockWrite(ref offset, game);
					bool found_stream = q[i].RomStreamWrite(ref offset,  game);
					if(found_block == true && found_stream == true){
						q.RemoveAt(i);
						break;
					}
				}
				Debug.Assert(prev_offset != offset);
				prev_offset = offset;
			}
			//fill
			for(int i = offset; i < size; i++){
				game[i] = 0xff;
			}
			return game;
		}
		void copy(byte [] input, ref int offset, ref byte []concat)
		{
			input.CopyTo(concat, offset);
			offset += input.Length;
		}
		byte[] rom_make(int romsize, byte[] manage, byte [] bios_extra, byte [] bios_bottom, byte [] game)
		{
			byte [] rom = new byte [romsize];
			int offset = 0;
			copy(game, ref offset, ref rom);
			copy(manage, ref offset, ref rom);
			copy(bios_extra, ref offset, ref rom);
			copy(bios_bottom, ref offset, ref rom);
			Debug.Assert(offset == rom.Length);
			return rom;
		}
		public bool Link(byte [] bios_bottom, byte [] bios_extra, out byte [] rom, out string[] log)
		{
			List<string> loglist = new List<string>();
			rom = null;
			//RAM の使用状況を探る
			if(savedata_search(m_image, m_workram) == false){
				loglist.Add("W-RAM for disk area is none");
				log = loglist.ToArray();
				return false;
			}
			if(m_workram.BufferAllocate(loglist) == false){
				log = loglist.ToArray();
				return false;
			}
			int romsize;
			if(output_romsize_calc(m_image, m_workram, out romsize, out m_blockuse, out m_streamuse, loglist) == false){
				loglist.Add("ROM capacity over!");
				log = loglist.ToArray();
				return false;
			}
			rom_allocate(m_image, 0, m_blockuse * mmc5.PAGESIZE);
			byte [] manage = manage_make(m_image, m_workram);
			byte [] game = game_make(m_image, romsize - (mmc5.PAGESIZE * 2));
			rom = rom_make(romsize, manage, bios_extra, bios_bottom, game);
			log = loglist.ToArray();
			return true;
		}
	}
	public class W_Ram{
		public enum board {
			ELROM = 0, EKROM, EWROM,
			ETROM_6264_6264, ETROM_6264_62256, ETROM_62256_62256
		};
		enum page_attribute{
			NOTHING, WITHBATTERY, NONBATTERY
		};
		enum page_reserve{
			OUTOFMEMORY, SAVE_EMPTY, 
			BUFFER, SAVE_RESERVED_ROM, SAVE_RESERVED_DISK
		};
		readonly board m_board;
		readonly page_attribute[] m_page_attribute;
		readonly page_reserve[] m_page_reserve;
		const int DISK_SAVEFILE_START_OFFSET = 0x10;
		int m_disk_save_offset = DISK_SAVEFILE_START_OFFSET;
		readonly Queue <imagefile.SaveArgument> m_disk_save_data = new Queue<imagefile.SaveArgument>();
		readonly List <imagefile.SaveArgument> m_rom_save_data = new List<imagefile.SaveArgument>();
		void reserve_init(page_attribute[] attribute, out page_reserve [] reserve)
		{
			reserve = new page_reserve[attribute.Length];
			for(int i = 0; i < attribute.Length; i++){
				switch(attribute[i]){
				case page_attribute.NOTHING:
					reserve[i] = page_reserve.OUTOFMEMORY;
					break;
				case page_attribute.WITHBATTERY:
					reserve[i] = page_reserve.SAVE_EMPTY;
					break;
				case page_attribute.NONBATTERY:
					reserve[i] = page_reserve.BUFFER;
					break;
				}
			}
		}
		public W_Ram(board t)
		{
			m_board = t;
			switch(t){
			case board.ELROM:
				m_page_attribute = new page_attribute[] {
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING
				};
				break;
			case board.EKROM:
				m_page_attribute = new page_attribute[] {
					page_attribute.WITHBATTERY, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING
				};
				break;
			case board.EWROM:
				m_page_attribute = new page_attribute[] {
					page_attribute.WITHBATTERY, page_attribute.WITHBATTERY, 
					page_attribute.WITHBATTERY, page_attribute.WITHBATTERY, 
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING
				};
				break;
			case board.ETROM_6264_6264:
				m_page_attribute = new page_attribute[] {
					page_attribute.WITHBATTERY, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NONBATTERY, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING
				};
				break;
			case board.ETROM_6264_62256:
				m_page_attribute = new page_attribute[] {
					page_attribute.WITHBATTERY, page_attribute.NOTHING, 
					page_attribute.NOTHING, page_attribute.NOTHING, 
					page_attribute.NONBATTERY, page_attribute.NONBATTERY, 
					page_attribute.NONBATTERY, page_attribute.NONBATTERY
				};
				break;
			case board.ETROM_62256_62256:
				m_page_attribute = new page_attribute[] {
					page_attribute.WITHBATTERY, page_attribute.WITHBATTERY, 
					page_attribute.WITHBATTERY, page_attribute.WITHBATTERY, 
					page_attribute.NONBATTERY, page_attribute.NONBATTERY, page_attribute.NONBATTERY, page_attribute.NONBATTERY
				};
				break;
			}
			Debug.Assert(m_page_attribute.Length == 8);
			reserve_init(m_page_attribute, out m_page_reserve);
		}
		public bool DiskBufferRequest()
		{
			switch(m_board){
			case board.ETROM_62256_62256:
			case board.ETROM_6264_62256:
				return true;
			}
			return false;
		}
		int diskpage_num_get(int offset)
		{
			int num = offset / hardware.mmc5.PAGESIZE;
			if((offset % hardware.mmc5.PAGESIZE) != 0){
				num += 1;
			}
			return num;
		}
		public void DiskPagenumAdd(List<byte> list)
		{
			list.Add((byte) diskpage_num_get(m_disk_save_offset));
		}
		bool disksave_allocate(List<string> log)
		{
			int disksavepagenum = diskpage_num_get(m_disk_save_offset);
			if(disksavepagenum >= 2){ //bios でいまのところ対応できないので弾く
				return false;
			}
			for(int i = 0; i < m_page_reserve.Length; i++){
				if(m_page_reserve[i] == page_reserve.SAVE_EMPTY){
					m_page_reserve[i] = page_reserve.SAVE_RESERVED_DISK;
					disksavepagenum -= 1;
					if(disksavepagenum == 0){
						break;
					}
				}
			}
			if(disksavepagenum != 0){
				log.Add("savedata area for disk is not enough");
				return false;
			}
			int offset = DISK_SAVEFILE_START_OFFSET;
			foreach(imagefile.SaveArgument t in m_disk_save_data.ToArray()){
				log.Add(String.Format("savefile 0x{0:x4}:{1}{2} allocated/ 0x{3:x4}byte", offset, t.Side, t.Name, t.Length));
				offset += t.Length;
			}
			Debug.Assert(offset == m_disk_save_offset);
			return true;
		}
		public void DiskSaveRequest(imagefile.SaveArgument s)
		{
			s.RamOffset = m_disk_save_offset;
			m_disk_save_data.Enqueue(s);
			m_disk_save_offset += s.Length;
		}
		public void RomSaveRequest(imagefile.SaveArgument s)
		{
			s.RamOffset = 0;
			m_rom_save_data.Add(s);
		}
		bool romsave_allocate(List<string> log)
		{
			Queue<int> page = new Queue<int>();
			int savepagenum = m_rom_save_data.Count;
			for(int i = 0; i < m_page_reserve.Length; i++){
				if(m_page_reserve[i] == page_reserve.SAVE_EMPTY){
					m_page_reserve[i] = page_reserve.SAVE_RESERVED_ROM;
					savepagenum -= 1;
					page.Enqueue(i);
					if(savepagenum == 0){
						break;
					}
				}
			}
			if(savepagenum != 0){
				log.Add("savedata area for ROM is not enough");
				return false;
			}
			foreach(imagefile.SaveArgument t in m_rom_save_data.ToArray()){
				log.Add(String.Format("save RAM 0x{0:x4}:{1} allocated",page.Dequeue() * mmc5.PAGESIZE, t.Name));
			}
			return true;
		}
		public bool BufferAllocate(List<string> log)
		{
			if(m_disk_save_data.Count != 0){
				if(disksave_allocate(log) == false){
					return false;
				}
			}
			if(m_rom_save_data.Count != 0){
				if(romsave_allocate(log) == false){
					return false;
				}
			}
			for(int i = 0; i < m_page_reserve.Length; i++){
				if(m_page_reserve[i] == page_reserve.SAVE_EMPTY){
					m_page_reserve[i] = page_reserve.BUFFER;
				}
			}
			log.Add(String.Format("bufferarea {0} page allocated", this.CpuromBufferCount()));
			return true;
		}
		//disk と ROM の savearea を確保してからやること!
		public bool CpuromWorkRequest()
		{
			return CpuromBufferGet().Count != 0;
		}
		public int CpuromBufferCount()
		{
			return CpuromBufferGet().Count;
		}
		public Queue<byte> CpuromBufferGet()
		{
			Queue<byte> buffer = new Queue<byte>();
			byte page = 0;
			foreach(page_reserve t in m_page_reserve){
				if(t == page_reserve.BUFFER){
					buffer.Enqueue(page);
				}
				page += 1;
			}
			return buffer;
		}
		public bool CpuromSaveRequest(out int page)
		{
			page = 0;
			foreach(page_reserve t in m_page_reserve){
				if(t == page_reserve.SAVE_RESERVED_ROM){
					return true;
				}
				page++;
			}
			return false;
		}
		public void DisksaveManegeWrite(int count, List<byte> manage)
		{
			while(count != 0){
				imagefile.SaveArgument s = m_disk_save_data.Dequeue();
				m6502.word_add(manage, s.Length);
				mmc5.rom_offset_add(s.ImageOffset, manage);
				mmc5.ram_offset_add(s.RamOffset, manage);
				count--;
			}
		}
		~W_Ram()
		{
			Debug.Assert(m_disk_save_data.Count == 0);
		}
	}
	class BgString{
		const string BGNAME_PATTERN = (
			"0ァゥェォッャュっゃゅ" +
			"!！「」ー-?゛゜" +
			"いろはにほへと" + "ちりぬるを" +
			"わかよたれそ" +   "つねならむ" +
			"うのおくやま" + "けふこえて" +
			"あさきゆめみし" + "ょひもせすん" +
			"イロハニホヘト" + "チリヌルヲ" +
			"ワカヨタレソ" +   "ツネナラム" +
			"ウィノオクヤマ" + "ケフコエテ" +
			"アサキユメミシ" + "ョヒモセスン"
		);
		readonly Dictionary<char, byte> m_bgname;
		public BgString()
		{
			m_bgname = new Dictionary<char, byte>();
			m_bgname.Add('\0', 0);
			//0x01-0x09 '1' から '9'
			for(int i = 1; i < 10; i++){
				char c = Convert.ToChar('0' + i);
				m_bgname.Add(c, (byte) i);
			}
			//0x0a-0x23 'A' から 'Z'
			for(int i = 0; i <= 'Z' - 'A'; i++){
				char c = Convert.ToChar('A' + i);
				m_bgname.Add(c, (byte) (i + 0x0a));
			}
			m_bgname.Add(' ', 0x24);
			m_bgname.Add(',', 0x25);
			m_bgname.Add('.', 0x26);
			for(int i = 0; i < BGNAME_PATTERN.Length; i++){
				char c = Convert.ToChar(BGNAME_PATTERN.Substring(i, 1));
				m_bgname.Add(c, (byte) (i + 0x88));
			}
		}
		public void StringSet(string str, List<byte> rom)
		{
			//文字の値が見つからないエラー処理はいれないので、script取り込み時に弾くこと.
			int i;
			for(i = 0; i < str.Length; i++){
				Debug.Assert(m_bgname.ContainsKey(str[i]));
				rom.Add(m_bgname[str[i]]);
			}
			//4byte alignment にして 6502 の処理時間を稼ぐ
			if((i % 4) != 0){
				int pad = 4 - str.Length % 4;
				for(i = 0; i < pad; i++){
					rom.Add(m_bgname[' ']);
				}
			}
			rom.Add(m_bgname['\0']);
		}
	}
/*	class image{
		mdc5.Script.imagetype m_type;
		readonly string m_name, m_code, m_version;
	}
	class disk : image{
		const int SIDE_MAX = 8;
		int m_side_count;
		stream[] m_side_top;
		diskfile[] savefile;
	}
	class diskfile{
		memory_pointer m_data;
		int m_side;
		int m_disk_offset;
	}
	class memory_pointer{
		enum page_type{
			relative, absolute_rom, absolute_ram
		};
		enum region{
			cpu, ppu
		};
		page_type m_page_type;
		region m_region;
		int m_page;
		int m_address;
	}
*/
}
