// parse_tree.h c\؂̃f
#ifndef __MERCURY_PARSE_TREE__
#define __MERCURY_PARSE_TREE__

#include <cstddef>
#include "nfa.h"


namespace mercury
{
	////////////////////////////////////////////////////////////////////////////////
	// \؂̒ۃNX
	template<typename _Input>
	class parse_tree
	{
	public:
		parse_tree(void) {}
		virtual ~parse_tree(void) {}

	public:
		// NFA\z
		virtual nfa<_Input> build_nfa(state_t &state) const = 0;

		// 
		virtual void free(void) { delete this; }
	};

	////////////////////////////////////////////////////////////////////////////////
	// \؂̎
	// \؂deleteZqł͂Ȃfreeo֐gĉKv邽߁A
	// std::auto_ptȓɎNXg
	template<typename _Input>
	class auto_parse_tree_ptr
	{
	public:
		explicit auto_parse_tree_ptr(parse_tree<_Input> *ptr) { m_owner = true; m_ptr = ptr; }
		 auto_parse_tree_ptr(auto_parse_tree_ptr<_Input> &rhs) { m_owner = rhs.m_owner; m_ptr = rhs.m_ptr; rhs.m_owner = false; rhs.m_ptr = NULL; }
		~auto_parse_tree_ptr(void)
		{
			if(m_owner && m_ptr != NULL)
			{
				m_ptr->free();
			}
		}

	public:
		// Zq̎
		// std::auto_ptr̂悤ɔėpKvȂ킯ł͂Ȃ̂ŁAKvŏ̂̂̂ݎ
		parse_tree<_Input> *operator->(void) const { return m_ptr; }

	private:
		bool m_owner;
		parse_tree<_Input> *m_ptr;
	};
}

#endif // __MERCURY_PARSE_TREE__
