// regex.h cK\
// ȉ̋LQlɁAR[hC++ɈڐAEg
// http://codezine.jp/article/detail/3039/
#ifndef __MERCURY_REGEX__
#define __MERCURY_REGEX__

#include "nfa.h"
#include "dfa.h"
#include "_regex/parser.h"
#include "_regex/traits.h"


namespace mercury
{
	template<typename _Char, typename _Traits = _regex::regex_traits<_Char> >
	class basic_regex
	{
	public:
		// RXgN^
		basic_regex(const _Char *pattern_string, const size_t pattern_length) : m_nfa(STATE_ERROR), m_dfa(STATE_ERROR)
		{
			_init(&pattern_string[0], &pattern_string[pattern_length]);
		}
		template<typename _Container>
		basic_regex(const _Container &pattern) : m_nfa(STATE_ERROR), m_dfa(STATE_ERROR)
		{
			_init(pattern.begin(), pattern.end());
		}
		template<typename _ConstIterator>
		basic_regex(const _ConstIterator &pattern_begin, const _ConstIterator &pattern_end) : m_nfa(STATE_ERROR), m_dfa(STATE_ERROR)
		{
			_init(pattern_begin, pattern_end);
		}

		// Sv
		bool match(const _Char *text_string, const size_t text_length) const
		{
			return match(&text_string[0], &text_string[text_length]);
		}
		template<typename _Container>
		bool match(const _Container &text) const
		{
			return match(text.begin(), text.end());
		}
		template<typename _ConstIterator>
		bool match(const _ConstIterator &text_begin, const _ConstIterator &text_end) const
		{
			// NFAGWƂē
			return m_nfa.can_accept(text_begin, text_end);
		}

	private:
		nfa<_Char> m_nfa;
		dfa<_Char> m_dfa;

		// Ce[^ɂ鏉
		template<typename _ConstIterator>
		void _init(const _ConstIterator &pattern_begin, const _ConstIterator &pattern_end)
		{
			// \́i\؂쐬j
			_regex::parser<_Char, _ConstIterator, _Traits> syntax(pattern_begin, pattern_end);
			auto_parse_tree_ptr<_Char> node(syntax.parse());

			// \؂NFA쐬
			state_t state = 0;
			m_nfa = node->build_nfa(state);

			// NFADFA̕ϊsSȂ̂ŁAƂ肠NFAGWƂē
/*
			// NFADFAɕϊ
			m_dfa = m_nfa.build_dfa();

			// DFAœK
			m_dfa.compact();
// */
		}
	};

	// char, wchar_tɂ͐p̖Ot
	typedef basic_regex< char  >  regex;
	typedef basic_regex<wchar_t> wregex;
}

#endif // __MERCURY_REGEX__
