// regex.h cK\
// ȉ̋LQlɁAR[hC++ɈڐAEg
// http://codezine.jp/article/detail/3039/
#ifndef __MERCURY_REGEX__
#define __MERCURY_REGEX__

#include <memory>
#include "nfa.h"
#include "dfa.h"
#include "_regex/parser.h"
#include "_regex/traits.h"


namespace mercury
{
	template<typename _Char, typename _Traits = _regex::regex_traits<_Char> >
	class basic_regex
	{
	public:
		typedef       _Char *      pointer;
		typedef const _Char *const_pointer;

		// v
		template<typename _InputOutputIterator>
		struct MATCH_INFO
		{
			size_t offset;                          // ItZbg
			size_t length;                          // v
			_InputOutputIterator begin;
			_InputOutputIterator end;

			// vCӂ̃ReiƂĎo
			template<typename _Container>
			_Container get(void) const { return _Container(begin, end); }
		};

	public:
		// RXgN^
		basic_regex(void)
		{
			_init();
		}
		basic_regex(const_pointer pattern_string)
		{
			_init();
			compile(pattern_string);
		}
		basic_regex(const_pointer pattern_string, const size_t pattern_length)
		{
			_init();
			compile(&pattern_string[0], &pattern_string[pattern_length]);
		}
		template<typename _Container>
		basic_regex(const _Container &pattern)
		{
			_init();
			compile(pattern.begin(), pattern.end());
		}
		template<typename _InputIterator>
		basic_regex(const _InputIterator &pattern_begin, const _InputIterator &pattern_end)
		{
			_init();
			compile(pattern_begin, pattern_end);
		}

		// RXgN^ȊOł̏
		basic_regex &operator=(const_pointer pattern_string)
		{
			compile(pattern_string);
			return *this;
		}
		template<typename _Container>
		basic_regex &operator=(const _Container &pattern)
		{
			compile(pattern);
			return *this;
		}
		void compile(const_pointer pattern_string)
		{
			compile(pattern_string, _Traits::length(pattern_string));
		}
		void compile(const_pointer pattern_string, const size_t pattern_length)
		{
			compile(&pattern_string[0], &pattern_string[pattern_length]);
		}
		template<typename _Container>
		void compile(const _Container &pattern)
		{
			compile(pattern.begin(), pattern.end());
		}
		template<typename _InputIterator>
		void compile(const _InputIterator &pattern_begin, const _InputIterator &pattern_end)
		{
			// \́i\؂쐬j
			_regex::parser<_Char, _InputIterator, _Traits> syntax(pattern_begin, pattern_end);
			std::auto_ptr<parse_tree<_Char> > tree(syntax.parse());

			// \؂NFA쐬
			state_t state = 0;
			m_nfa = tree->build_nfa(state);

			m_head = syntax.is_head();
			m_tail = syntax.is_tail();

			// NFADFA̕ϊsSȂ̂ŁAƂ肠NFAGWƂē
#if 0
			// NFADFAɕϊ
			m_dfa = m_nfa.build_dfa();

			// DFAœK
			m_dfa.compact();
#endif
		}

		// OvEv
		bool is_head(void) const { return m_head; }
		bool is_tail(void) const { return m_tail; }

		// }b`O
		//  z𕶎Ƃ
		template<typename _MATCH_INFO>
		bool match(const_pointer text_array, _MATCH_INFO &match_info) const
		{
			return match(text_array, _Traits::length(text_array), match_info);
		}
		template<typename _MATCH_INFO>
		bool match(const_pointer text_array, const size_t text_length, _MATCH_INFO &match_info) const
		{
			return match(&text_array[0], &text_array[text_length], match_info);
		}
		//  Rei𕶎Ƃ
		template<typename _Container, typename _MATCH_INFO>
		bool match(const _Container &text, _MATCH_INFO &match_info) const
		{
			return match(text.begin(), text.end(), match_info);
		}
		//  Ce[^𕶎Ƃ
		template<typename _InputIterator, typename _MATCH_INFO>
		bool match(const _InputIterator &text_begin, const _InputIterator &text_end, _MATCH_INFO &match_info) const
		{
			_MATCH_INFO info = {0, 0, text_begin, text_end};

			// ̒0ł1}b`OȂ΂Ȃ̂ŁA
			// P for(info.begin = text_begin; info.begin != text_end; info.begin++, info.offset++) Ƃ킯ɂ͂ȂB
			// ɁA2ڈȍ~͋󕶎Ƀ}b`Ă͂Ȃ̂ŁAdo`whilegƂłȂ̂
			// 1ڂ2ڈȍ~ʁXɏĂB
			// ̂߂ɃR[hȂA܂@ΉƂB
			if(_match_forward(info.begin, text_end, info.end, info.length))
			{
				// ṽ`FbN
				if(!is_tail() || info.end == text_end)
				{
					goto matched;
				}
			}

			if(!is_head() && text_begin != text_end)
			{
				while(++info.begin != text_end)
				{
					info.offset++;
					if(_match_forward(info.begin, text_end, info.end, info.length))
					{
						// ṽ`FbN
						if(!is_tail() || info.end == text_end)
						{
							goto matched;
						}
					}
				}
			}
			return false;

matched:
			// }b`ݒ
			match_info = info;
			return true;
		}

	private:
		bool m_head;
		bool m_tail;
		nfa<_Char> m_nfa;
		dfa<_Char> m_dfa;

		// 
		void _init(void)
		{
			m_head = false;
			m_tail = false;
		}

		// Ov`FbN
		template<typename _InputIterator, typename _OutputIterator>
		bool _match_forward(const _InputIterator &text_begin, const _InputIterator &text_end, _OutputIterator &match_end, size_t &match_length) const
		{
			// NFAGW
			return m_nfa.match_forward(text_begin, text_end, match_end, match_length);
		}
	};

	// char, wchar_tɂ͐p̖Ot
	typedef basic_regex< char  >  regex;
	typedef basic_regex<wchar_t> wregex;
}

#endif // __MERCURY_REGEX__
