/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class DelegatingModelPresentation
implements IDebugModelPresentation,
IDebugEditorPresentation {
    private HashMap fAttributes = new HashMap(3);
    private HashMap fLabelProviders = new HashMap(5);

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(thread);
        if (presentation != null && presentation instanceof IDebugEditorPresentation) {
            ((IDebugEditorPresentation)((Object)presentation)).removeAnnotations(editorPart, thread);
        }
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        IDebugModelPresentation presentation = this.getConfiguredPresentation(frame);
        if (presentation != null && presentation instanceof IDebugEditorPresentation) {
            return ((IDebugEditorPresentation)((Object)presentation)).addAnnotations(editorPart, frame);
        }
        return false;
    }

    public DelegatingModelPresentation() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "debugModelPresentations");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement elt = configElements[j];
                    String id = elt.getAttribute("id");
                    if (id != null) {
                        LazyModelPresentation lp = new LazyModelPresentation(elt);
                        this.getLabelProviders().put(id, lp);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
        Iterator i = this.getLabelProviders().values().iterator();
        while (i.hasNext()) {
            ((ILabelProvider)i.next()).addListener(listener);
        }
    }

    public void dispose() {
        Iterator i = this.getLabelProviders().values().iterator();
        while (i.hasNext()) {
            ((ILabelProvider)i.next()).dispose();
        }
    }

    public Image getImage(Object item) {
        Image image;
        IDebugModelPresentation lp = this.getConfiguredPresentation(item);
        if (lp != null && (image = lp.getImage(item)) != null) {
            return image;
        }
        return this.getDefaultImage(item);
    }

    public String getText(Object item) {
        String label;
        IDebugModelPresentation lp;
        if (!(item instanceof IndexedVariablePartition) && (lp = this.getConfiguredPresentation(item)) != null && (label = lp.getText(item)) != null) {
            return label;
        }
        if (this.showVariableTypeNames()) {
            try {
                if (item instanceof IExpression) {
                    StringBuffer buf = new StringBuffer();
                    IValue value = ((IExpression)item).getValue();
                    if (value != null) {
                        buf.append(value.getReferenceTypeName());
                        buf.append(' ');
                    }
                    buf.append(this.getDefaultText(item));
                    return buf.toString();
                }
                if (item instanceof IVariable) {
                    return ((IVariable)item).getValue().getReferenceTypeName() + ' ' + this.getDefaultText(item);
                }
            }
            catch (DebugException de) {
                DebugUIPlugin.log(de);
            }
        }
        return this.getDefaultText(item);
    }

    public IEditorInput getEditorInput(Object item) {
        IDebugModelPresentation lp = this.getConfiguredPresentation(item);
        if (lp != null) {
            return lp.getEditorInput(item);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object objectInput) {
        IDebugModelPresentation lp = this.getConfiguredPresentation(objectInput);
        if (lp != null) {
            return lp.getEditorId(input, objectInput);
        }
        return null;
    }

    protected String getDefaultText(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getText(element);
    }

    protected Image getDefaultImage(Object element) {
        return DebugUIPlugin.getDefaultLabelProvider().getImage(element);
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        IDebugModelPresentation lp = this.getConfiguredPresentation(value);
        if (lp != null) {
            lp.computeDetail(value, listener);
        } else {
            listener.detailComputed(value, this.getText(value));
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        Iterator i = this.getLabelProviders().values().iterator();
        while (i.hasNext()) {
            ((ILabelProvider)i.next()).removeListener(listener);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        IDebugModelPresentation lp;
        if (element instanceof IDebugElement && (lp = this.getConfiguredPresentation(element)) != null) {
            return lp.isLabelProperty(element, property);
        }
        return true;
    }

    protected IDebugModelPresentation getConfiguredPresentation(Object element) {
        String id = null;
        if (element instanceof IDebugElement) {
            IDebugElement de = (IDebugElement)element;
            id = de.getModelIdentifier();
        } else if (element instanceof IMarker) {
            IMarker m = (IMarker)element;
            IBreakpoint bp = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(m);
            if (bp != null) {
                id = bp.getModelIdentifier();
            }
        } else if (element instanceof IBreakpoint) {
            id = ((IBreakpoint)element).getModelIdentifier();
        }
        if (id != null) {
            return this.getPresentation(id);
        }
        return null;
    }

    public IDebugModelPresentation getPresentation(String id) {
        return (IDebugModelPresentation)this.getLabelProviders().get(id);
    }

    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        this.getAttributes().put(id, value);
        Iterator presentations = this.fLabelProviders.values().iterator();
        while (presentations.hasNext()) {
            ((IDebugModelPresentation)presentations.next()).setAttribute(id, value);
        }
    }

    protected boolean showVariableTypeNames() {
        Boolean show = (Boolean)this.fAttributes.get(IDebugModelPresentation.DISPLAY_VARIABLE_TYPE_NAMES);
        show = show == null ? Boolean.FALSE : show;
        return show;
    }

    protected HashMap getAttributes() {
        return this.fAttributes;
    }

    public Map getAttributeMap() {
        return (Map)this.getAttributes().clone();
    }

    protected void setAttributes(HashMap attributes) {
        this.fAttributes = attributes;
    }

    protected HashMap getLabelProviders() {
        return this.fLabelProviders;
    }

    protected void setLabelProviders(HashMap labelProviders) {
        this.fLabelProviders = labelProviders;
    }
}

