/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.FollowHyperlinkAction;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;

public class KeyBindingFollowHyperlinkAction
extends FollowHyperlinkAction {
    private boolean fSelectionNotAHyperlink = false;
    private IActionBars fActionBars;

    public KeyBindingFollowHyperlinkAction(ISelectionProvider selectionProvider, IActionBars actionBars) {
        super(selectionProvider);
        this.fActionBars = actionBars;
    }

    public void run() {
        IConsoleHyperlink link = this.getHyperLink();
        if (link == null) {
            IStatusLineManager statusLine = this.getStatusLineManager();
            if (statusLine != null) {
                statusLine.setErrorMessage(ActionMessages.getString("KeyBindingFollowHyperLinkAction.No_hyperlink"));
                this.fSelectionNotAHyperlink = true;
            }
            DebugUIPlugin.getStandardDisplay().beep();
        } else {
            link.linkActivated();
            this.fSelectionNotAHyperlink = false;
        }
    }

    public void clearStatusLine() {
        IStatusLineManager statusLine;
        if (this.fSelectionNotAHyperlink && (statusLine = this.getStatusLineManager()) != null) {
            statusLine.setErrorMessage(null);
            this.fSelectionNotAHyperlink = false;
        }
    }

    public void selectionChanged(ISelection selection) {
        if (this.isEmptySelection(selection)) {
            this.clearStatusLine();
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    protected boolean isEmptySelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() < 1;
        }
        return selection.isEmpty();
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.fActionBars.getStatusLineManager();
    }
}

