/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;

public class ModuleExpansion {
    private String moduleName;
    private String[] expansions;
    private Command.LocalOption[] options;

    ModuleExpansion(String moduleName, String[] expansions, Command.LocalOption[] options) {
        this.moduleName = moduleName;
        this.expansions = expansions;
        this.options = options;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getModuleExpansionString() {
        String result = this.expansions[0];
        int i = 1;
        while (i < this.expansions.length) {
            result = String.valueOf(result) + ", " + this.expansions[i];
            ++i;
        }
        return result;
    }

    public String[] getExpansions() {
        return this.expansions;
    }

    public Command.LocalOption[] getOptions() {
        return this.options;
    }

    private List getExpansionsFor(String[] possibleModules, Map moduleMappings, int depth) throws CVSException {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < possibleModules.length) {
            if (possibleModules[i].charAt(0) == '&') {
                result.addAll(this.getExpansionsFor(possibleModules[i].substring(1), moduleMappings, depth));
            } else {
                result.add(possibleModules[i]);
            }
            ++i;
        }
        return result;
    }

    private List getExpansionsFor(String module, Map moduleMappings, int depth) throws CVSException {
        if (depth > moduleMappings.size()) {
            throw new CVSException(Policy.bind("ModuleExpansion.circular", module));
        }
        Object mappings = moduleMappings.get(module);
        if (mappings == null) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(module);
            return result;
        }
        return this.getExpansionsFor(((ModuleExpansion)mappings).expansions, moduleMappings, depth + 1);
    }

    public void resolveModuleReferencesUsing(Map moduleMappings) {
        try {
            List result = this.getExpansionsFor(this.expansions, moduleMappings, 0);
            this.expansions = result.toArray(new String[result.size()]);
        }
        catch (CVSException e) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(e.getStatus().getMessage());
            result.addAll(Arrays.asList(this.expansions));
            this.expansions = result.toArray(new String[result.size()]);
        }
    }
}

