/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

public class TaskLinkManager {
    private static Map fgProcessToLinks;
    private static Map fgProcessToNewLines;
    private static List fgAntBuilds;

    private TaskLinkManager() {
    }

    public static synchronized void addTaskHyperlink(IProcess process, IConsoleHyperlink link, IRegion region, String message) {
        ArrayList<HyperlinkEntry> links;
        List newLines;
        if (fgProcessToNewLines != null && (newLines = (List)fgProcessToNewLines.get(process)) != null) {
            int index = 0;
            while (index < newLines.size()) {
                LineEntry newLine = (LineEntry)newLines.get(index);
                if (TaskLinkManager.addLink(newLine.getConsole(), link, newLine.getRegion(), region, message)) {
                    newLines.subList(0, index + 1).clear();
                    return;
                }
                ++index;
            }
        }
        if (fgProcessToLinks == null) {
            fgProcessToLinks = new HashMap();
        }
        if ((links = (ArrayList<HyperlinkEntry>)fgProcessToLinks.get(process)) == null) {
            links = new ArrayList<HyperlinkEntry>(10);
            fgProcessToLinks.put(process, links);
        }
        links.add(new HyperlinkEntry(link, region, message));
    }

    private static boolean addLink(IConsole console, IConsoleHyperlink link, IRegion lineRegion, IRegion region, String message) {
        String text;
        int length = region.getLength();
        try {
            text = console.getDocument().get(lineRegion.getOffset(), lineRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        if (text.trim().equals(message)) {
            int offset = lineRegion.getOffset() + region.getOffset();
            console.addLink(link, offset, length);
            return true;
        }
        return false;
    }

    public static synchronized void processNewLine(IConsole console, IRegion newLine) {
        IProcess process = console.getProcess();
        if (fgAntBuilds != null && fgAntBuilds.contains(process) && TaskLinkManager.linkBuildFileMessage(console, newLine)) {
            fgAntBuilds.remove(process);
            return;
        }
        if (fgProcessToLinks == null) {
            TaskLinkManager.addNewLine(console, newLine, process);
            return;
        }
        List links = (List)fgProcessToLinks.get(process);
        if (links == null) {
            TaskLinkManager.addNewLine(console, newLine, process);
            return;
        }
        int index = 0;
        while (index < links.size()) {
            HyperlinkEntry link = (HyperlinkEntry)links.get(index);
            if (TaskLinkManager.addLink(console, link.getLink(), newLine, link.getRegion(), link.getMessage())) {
                links.subList(0, index + 1).clear();
                return;
            }
            ++index;
        }
    }

    private static void addNewLine(IConsole console, IRegion newLine, IProcess process) {
        ArrayList<LineEntry> newLines;
        if (fgProcessToNewLines == null) {
            fgProcessToNewLines = new HashMap();
        }
        if ((newLines = (ArrayList<LineEntry>)fgProcessToNewLines.get(process)) == null) {
            newLines = new ArrayList<LineEntry>();
        }
        newLines.add(new LineEntry(console, newLine));
        fgProcessToNewLines.put(process, newLines);
    }

    public static void dispose(IProcess process) {
        if (fgProcessToLinks != null) {
            fgProcessToLinks.remove(process);
        }
        if (fgProcessToNewLines != null) {
            fgProcessToNewLines.remove(process);
        }
        if (fgAntBuilds != null) {
            fgAntBuilds.remove(process);
        }
    }

    public static synchronized void registerAntBuild(IProcess process) {
        List newLines;
        if (fgProcessToNewLines != null && (newLines = (List)fgProcessToNewLines.get(process)) != null) {
            Iterator iter = newLines.iterator();
            while (iter.hasNext()) {
                LineEntry newLine = (LineEntry)iter.next();
                if (!TaskLinkManager.linkBuildFileMessage(newLine.getConsole(), newLine.getRegion())) continue;
                iter.remove();
                return;
            }
        }
        if (fgAntBuilds == null) {
            fgAntBuilds = new ArrayList();
        }
        fgAntBuilds.add(process);
    }

    private static boolean linkBuildFileMessage(IConsole console, IRegion region) {
        String fileName;
        IFile file;
        String message = "";
        int offset = region.getOffset();
        try {
            message = console.getDocument().get(offset, region.getLength());
        }
        catch (BadLocationException badLocationException) {}
        if (message.startsWith("Buildfile:") && (file = AntUtil.getFileForLocation(fileName = message.substring(10).trim(), null)) != null) {
            FileLink link = new FileLink(file, null, -1, -1, -1);
            console.addLink((IConsoleHyperlink)link, offset + 11, fileName.length());
            return true;
        }
        return false;
    }

    private static class HyperlinkEntry {
        private IConsoleHyperlink fLink;
        private IRegion fRegion;
        private String fMessage;

        public HyperlinkEntry(IConsoleHyperlink link, IRegion region, String message) {
            this.fLink = link;
            this.fRegion = region;
            this.fMessage = message;
        }

        public IRegion getRegion() {
            return this.fRegion;
        }

        public IConsoleHyperlink getLink() {
            return this.fLink;
        }

        public String getMessage() {
            return this.fMessage;
        }
    }

    private static class LineEntry {
        private IConsole fConsole;
        private IRegion fRegion;

        public LineEntry(IConsole console, IRegion region) {
            this.fConsole = console;
            this.fRegion = region;
        }

        public IRegion getRegion() {
            return this.fRegion;
        }

        public IConsole getConsole() {
            return this.fConsole;
        }
    }
}

