/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.preferences.AntClasspathBlock;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.ant.internal.ui.preferences.ClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.GlobalClasspathEntries;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class AntClasspathLabelProvider
implements ILabelProvider,
IColorProvider {
    private AntClasspathBlock fBlock;

    public AntClasspathLabelProvider(AntClasspathBlock block) {
        this.fBlock = block;
    }

    private Image getFolderImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    private Image getJarImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_JAR_FILE");
    }

    public Image getClasspathImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_TAB_CLASSPATH");
    }

    public Image getImage(Object element) {
        if (element instanceof ClasspathEntry) {
            ClasspathEntry entry = (ClasspathEntry)element;
            String file = entry.toString();
            if (file.endsWith("/")) {
                return this.getFolderImage();
            }
            return this.getJarImage();
        }
        return this.getClasspathImage();
    }

    public String getText(Object element) {
        if (element instanceof IAntClasspathEntry) {
            StringBuffer label = new StringBuffer(((IAntClasspathEntry)element).getLabel());
            if (element instanceof GlobalClasspathEntries && ((GlobalClasspathEntries)element).getType() == 0) {
                AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
                String defaultAntHome = prefs.getDefaultAntHome();
                String currentAntHome = this.fBlock.getAntHome();
                label.append(" (");
                if (defaultAntHome.equals(currentAntHome)) {
                    label.append(AntPreferencesMessages.getString("AntClasspathLabelProvider.0"));
                } else {
                    label.append(this.fBlock.getAntHome());
                }
                label.append(')');
            }
            return label.toString();
        }
        return element.toString();
    }

    public Color getBackground(Object element) {
        if (element instanceof GlobalClasspathEntries) {
            Display display = Display.getCurrent();
            return display.getSystemColor(29);
        }
        boolean cfr_ignored_0 = element instanceof ClasspathEntry;
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

