/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorManager;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ThreadsViewContentProvider
implements ITreeContentProvider {
    protected TreeViewer fViewer = null;

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ThreadWrapper) {
            IJavaThread thread = ((ThreadWrapper)parentElement).thread;
            IJavaObject[] ownedMonitors = MonitorManager.getDefault().getOwnedMonitors(thread);
            IJavaObject contendedMonitor = MonitorManager.getDefault().getContendedMonitor(thread);
            if (ownedMonitors == null && contendedMonitor == null) {
                return null;
            }
            int size = 0;
            if (ownedMonitors != null) {
                size = ownedMonitors.length;
            }
            if (contendedMonitor != null) {
                ++size;
            }
            Object[] children = new Object[size];
            if (ownedMonitors != null) {
                int i = 0;
                while (i < ownedMonitors.length) {
                    MonitorWrapper mw = new MonitorWrapper();
                    mw.monitor = ownedMonitors[i];
                    mw.state = 1;
                    children[i] = mw;
                    ++i;
                }
            }
            if (contendedMonitor != null) {
                MonitorWrapper mw = new MonitorWrapper();
                mw.monitor = contendedMonitor;
                mw.state = 2;
                children[children.length - 1] = mw;
            }
            return children;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IJavaThread) {
            return MonitorManager.getDefault().getOwnedMonitors((IJavaThread)element);
        }
        if (element instanceof IJavaObject) {
            return MonitorManager.getDefault().getOwningThread((IJavaObject)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IJavaThread) {
            IJavaThread thread = (IJavaThread)element;
            IJavaObject[] ownedMonitors = MonitorManager.getDefault().getOwnedMonitors(thread);
            IJavaObject contendedMonitor = MonitorManager.getDefault().getContendedMonitor(thread);
            return ownedMonitors != null || contendedMonitor != null;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        IJavaThread[] allThreads = MonitorManager.getDefault().getThreads();
        Object[] res = new Object[allThreads.length];
        int i = 0;
        while (i < allThreads.length) {
            ThreadWrapper tw = new ThreadWrapper();
            tw.thread = allThreads[i];
            tw.isCaughtInDeadlock = MonitorManager.getDefault().isCaughtInDeadlock(allThreads[i]);
            res[i] = tw;
            ++i;
        }
        return res;
    }

    public void dispose() {
        this.fViewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public class MonitorWrapper {
        public static final int OWNED_MONITOR = 1;
        public static final int CONTENDED_MONITOR = 2;
        public IJavaObject monitor;
        public int state;
    }

    public class ThreadWrapper {
        public IJavaThread thread;
        public boolean isCaughtInDeadlock;
    }
}

