/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractBundleData;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleEntry;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.protocol.bundleresource.Handler;

public abstract class BundleFile {
    protected File basefile;

    public BundleFile(File basefile) {
        this.basefile = basefile;
    }

    public abstract File getFile(String var1);

    public abstract BundleEntry getEntry(String var1);

    public abstract Enumeration getEntryPaths(String var1);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public abstract boolean containsDir(String var1);

    public URL getResourceURL(String path, long hostBundleID) {
        BundleEntry bundleEntry = this.getEntry(path);
        if (bundleEntry == null) {
            return null;
        }
        try {
            StringBuffer url = new StringBuffer("bundleresource");
            url.append("://").append(hostBundleID);
            if (path.length() == 0 || path.charAt(0) != '/') {
                url.append('/');
            }
            url.append(path);
            return new URL(null, url.toString(), new Handler(bundleEntry));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public File getBaseFile() {
        return this.basefile;
    }

    public static class ZipBundleFile
    extends BundleFile {
        protected BundleData bundledata;
        protected ZipFile zipFile;
        protected boolean closed = false;

        public ZipBundleFile(File basefile, BundleData bundledata) throws IOException {
            super(basefile);
            this.bundledata = bundledata;
            this.closed = true;
            this.open();
        }

        protected ZipEntry getZipEntry(String path) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            return this.zipFile.getEntry(path);
        }

        protected File extractDirectory(String dirName) {
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                String entryPath = entries.nextElement().getName();
                if (!entryPath.startsWith(dirName) || entryPath.endsWith("/")) continue;
                this.getFile(entryPath);
            }
            return this.getExtractFile(dirName);
        }

        protected File getExtractFile(String entryName) {
            if (!(this.bundledata instanceof AbstractBundleData)) {
                return null;
            }
            File bundleGenerationDir = ((AbstractBundleData)this.bundledata).createGenerationDir();
            if (bundleGenerationDir != null && bundleGenerationDir.exists()) {
                String path = ".cp";
                String name = entryName.replace('/', File.separatorChar);
                path = name.length() > 1 && name.charAt(0) == File.separatorChar ? path.concat(name) : String.valueOf(path) + File.separator + name;
                return new File(bundleGenerationDir, path);
            }
            return null;
        }

        public File getFile(String entry) {
            block15: {
                ZipEntry zipEntry = this.getZipEntry(entry);
                if (zipEntry == null) {
                    return null;
                }
                try {
                    File nested = this.getExtractFile(zipEntry.getName());
                    if (nested != null) {
                        if (nested.exists()) {
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println((String)("File already present: " + nested.getPath()));
                            }
                        } else if (zipEntry.getName().endsWith("/")) {
                            if (!nested.mkdirs()) {
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println((String)("Unable to create directory: " + nested.getPath()));
                                }
                                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)nested.getAbsolutePath()));
                            }
                            this.extractDirectory(zipEntry.getName());
                        } else {
                            File dir;
                            InputStream in = this.zipFile.getInputStream(zipEntry);
                            if (in == null) {
                                return null;
                            }
                            if (Debug.DEBUG_GENERAL) {
                                Debug.println((String)("Creating file: " + nested.getPath()));
                            }
                            if (!(dir = new File(nested.getParent())).exists() && !dir.mkdirs()) {
                                if (Debug.DEBUG_GENERAL) {
                                    Debug.println((String)("Unable to create directory: " + dir.getPath()));
                                }
                                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)dir.getAbsolutePath()));
                            }
                            AbstractFrameworkAdaptor.readFile(in, nested);
                        }
                        return nested;
                    }
                }
                catch (IOException e) {
                    if (!Debug.DEBUG_GENERAL) break block15;
                    Debug.printStackTrace((Throwable)e);
                }
            }
            return null;
        }

        public boolean containsDir(String dir) {
            if (dir == null) {
                return false;
            }
            if (dir.length() == 0) {
                return true;
            }
            if (dir.charAt(0) == '/') {
                dir = dir.substring(0);
            }
            if (dir.length() > 0 && dir.charAt(dir.length() - 1) != '/') {
                dir = String.valueOf(dir) + '/';
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(dir)) continue;
                return true;
            }
            return false;
        }

        public BundleEntry getEntry(String path) {
            ZipEntry zipEntry = this.getZipEntry(path);
            if (zipEntry == null) {
                if ((path.length() == 0 || path.charAt(path.length() - 1) == '/') && this.containsDir(path)) {
                    return new BundleEntry.DirZipBundleEntry(this, path);
                }
                return null;
            }
            return new BundleEntry.ZipBundleEntry(this.zipFile, zipEntry, this);
        }

        public Enumeration getEntryPaths(String path) {
            if (path == null) {
                throw new NullPointerException();
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                path = path + "/";
            }
            Vector<String> vEntries = new Vector<String>();
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryPath = zipEntry.getName();
                if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
                if (entryPath.lastIndexOf(47) < path.length()) {
                    vEntries.add(entryPath);
                    continue;
                }
                entryPath = entryPath.substring(path.length());
                int slash = entryPath.indexOf(47);
                entryPath = String.valueOf(path) + entryPath.substring(0, slash + 1);
                if (vEntries.contains(entryPath)) continue;
                vEntries.add(entryPath);
            }
            return vEntries.elements();
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.zipFile.close();
            }
        }

        public void open() throws IOException {
            if (this.closed) {
                this.zipFile = new ZipFile(this.basefile);
                this.closed = false;
            }
        }
    }

    public static class DirBundleFile
    extends BundleFile {
        public DirBundleFile(File basefile) throws IOException {
            super(basefile);
            if (!basefile.exists() || !basefile.isDirectory()) {
                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_EXCEPTION", (Object)basefile));
            }
        }

        public File getFile(String path) {
            File filePath = new File(this.basefile, path);
            if (filePath.exists()) {
                return filePath;
            }
            return null;
        }

        public BundleEntry getEntry(String path) {
            File filePath = new File(this.basefile, path);
            if (!filePath.exists()) {
                return null;
            }
            return new BundleEntry.FileBundleEntry(filePath, path);
        }

        public boolean containsDir(String dir) {
            File dirPath = new File(this.basefile, dir);
            return dirPath.exists() && dirPath.isDirectory();
        }

        public Enumeration getEntryPaths(String path) {
            File pathFile = new File(this.basefile, path);
            if (!pathFile.exists()) {
                return new Enumeration(this){
                    final /* synthetic */ DirBundleFile this$1;
                    {
                        this.this$1 = dirBundleFile;
                    }

                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        throw new NoSuchElementException();
                    }
                };
            }
            if (pathFile.isDirectory()) {
                String[] fileList = pathFile.list();
                String dirPath = path.length() == 0 || path.charAt(path.length() - 1) == '/' ? path : String.valueOf(path) + '/';
                return new Enumeration(this, fileList, pathFile, dirPath){
                    int cur;
                    final /* synthetic */ DirBundleFile this$1;
                    private final /* synthetic */ String[] val$fileList;
                    private final /* synthetic */ File val$pathFile;
                    private final /* synthetic */ String val$dirPath;
                    {
                        this.this$1 = dirBundleFile;
                        this.val$fileList = stringArray;
                        this.val$pathFile = file;
                        this.val$dirPath = string;
                        this.cur = 0;
                    }

                    public boolean hasMoreElements() {
                        return this.cur < this.val$fileList.length;
                    }

                    public Object nextElement() {
                        if (this.cur >= this.val$fileList.length) {
                            throw new NoSuchElementException();
                        }
                        File childFile = new File(this.val$pathFile, this.val$fileList[this.cur]);
                        StringBuffer sb = new StringBuffer(this.val$dirPath).append(this.val$fileList[this.cur++]);
                        if (childFile.isDirectory()) {
                            sb.append("/");
                        }
                        return sb.toString();
                    }
                };
            }
            return new Enumeration(this, path){
                int cur;
                final /* synthetic */ DirBundleFile this$1;
                private final /* synthetic */ String val$path;
                {
                    this.this$1 = dirBundleFile;
                    this.val$path = string;
                    this.cur = 0;
                }

                public boolean hasMoreElements() {
                    return this.cur < 1;
                }

                public Object nextElement() {
                    if (this.cur == 0) {
                        this.cur = 1;
                        return this.val$path;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        public void close() {
        }

        public void open() {
        }
    }

    public static class NestedDirBundleFile
    extends BundleFile {
        BundleFile baseBundleFile;
        String cp;

        public NestedDirBundleFile(BundleFile baseBundlefile, String cp) {
            super(baseBundlefile.basefile);
            this.baseBundleFile = baseBundlefile;
            this.cp = cp;
            if (cp.charAt(cp.length() - 1) != '/') {
                this.cp = String.valueOf(this.cp) + '/';
            }
        }

        public void close() {
        }

        public BundleEntry getEntry(String path) {
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            String newpath = this.cp + path;
            return this.baseBundleFile.getEntry(newpath);
        }

        public boolean containsDir(String dir) {
            if (dir == null) {
                return false;
            }
            if (dir.length() > 0 && dir.charAt(0) == '/') {
                dir = dir.substring(1);
            }
            String newdir = this.cp + dir;
            return this.baseBundleFile.containsDir(newdir);
        }

        public Enumeration getEntryPaths(String path) {
            return null;
        }

        public File getFile(String entry) {
            return null;
        }

        public void open() {
        }
    }
}

