/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagConfigurationDialog;
import org.eclipse.team.internal.ccvs.ui.merge.TagElement;
import org.eclipse.team.internal.ccvs.ui.merge.TagRootElement;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TagAsVersionDialog
extends DetailsDialog {
    private ITagOperation operation;
    private ICVSFolder folder;
    private Text tagText;
    private Button moveTagButton;
    private String tagName = "";
    private boolean moveTag = false;
    private static final int TABLE_HEIGHT_HINT = 150;
    private TableViewer existingVersionTable;

    public TagAsVersionDialog(Shell parentShell, String title, ITagOperation operation) {
        super(parentShell, title);
        this.folder = this.getFirstFolder(operation.getCVSResources());
        this.operation = operation;
    }

    private ICVSFolder getFirstFolder(ICVSResource[] resources) {
        if (resources[0].isFolder()) {
            return (ICVSFolder)resources[0];
        }
        return resources[0].getParent();
    }

    protected void createMainDialogArea(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(Policy.bind("TagAction.enterTag"));
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        this.tagText = new Text(parent, 2052);
        this.tagText.setLayoutData((Object)new GridData(768));
        this.tagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TagAsVersionDialog.this.tagName = TagAsVersionDialog.this.tagText.getText();
                TagAsVersionDialog.this.updateEnablements();
            }
        });
        this.moveTagButton = new Button(parent, 32);
        this.moveTagButton.setText(Policy.bind("TagAction.moveTag"));
        this.moveTagButton.setLayoutData((Object)new GridData(1796));
        this.moveTagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagAsVersionDialog.this.moveTag = TagAsVersionDialog.this.moveTagButton.getSelection();
            }
        });
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.team.cvs.ui.tag_as_version_dialog_context");
        Dialog.applyDialogFont((Control)parent);
    }

    public boolean shouldMoveTag() {
        return this.moveTag;
    }

    protected TableViewer createTable(Composite parent) {
        Table table = new Table(parent, 68356);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
        table.setLayout((Layout)layout);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        return new TableViewer(table);
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 64);
        label.setText(Policy.bind("TagAction.existingVersions"));
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        this.existingVersionTable = this.createTable(composite);
        this.existingVersionTable.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.existingVersionTable.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.existingVersionTable.setSorter(new ViewerSorter(){

            public int compare(Viewer v, Object o1, Object o2) {
                int result = super.compare(v, o1, o2);
                if (o1 instanceof TagElement && o2 instanceof TagElement) {
                    return -result;
                }
                return result;
            }
        });
        this.existingVersionTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TagElement element;
                IStructuredSelection selection = (IStructuredSelection)TagAsVersionDialog.this.existingVersionTable.getSelection();
                if (!selection.isEmpty() && (element = (TagElement)((IStructuredSelection)TagAsVersionDialog.this.existingVersionTable.getSelection()).getFirstElement()) != null) {
                    TagAsVersionDialog.this.tagText.setText(element.getTag().getName());
                }
            }
        });
        Runnable afterRefresh = new Runnable(){

            public void run() {
                TagAsVersionDialog.this.getShell().getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TagAsVersionDialog.access$4(5.access$0(this.this$1)).refresh();
                    }
                });
            }

            static /* synthetic */ TagAsVersionDialog access$0(5 var0) {
                return var0.TagAsVersionDialog.this;
            }
        };
        Runnable afterConfigure = new Runnable(){

            public void run() {
                TagAsVersionDialog.this.getShell().getDisplay().syncExec(new Runnable(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        TagAsVersionDialog.access$4(7.access$0(this.this$1)).setInput((Object)new TagRootElement(TagAsVersionDialog.access$5(7.access$0(this.this$1)), 2));
                    }
                });
            }

            static /* synthetic */ TagAsVersionDialog access$0(7 var0) {
                return var0.TagAsVersionDialog.this;
            }
        };
        TagConfigurationDialog.createTagDefinitionButtons(this.getShell(), composite, new ICVSFolder[]{this.folder}, this.convertVerticalDLUsToPixels(14), this.convertHorizontalDLUsToPixels(61), afterRefresh, afterConfigure);
        this.existingVersionTable.setInput((Object)new TagRootElement(this.folder, 2));
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void updateEnablements() {
        String message = null;
        if (this.tagName.length() == 0) {
            message = "";
        } else {
            IStatus status = CVSTag.validateTagName((String)this.tagName);
            if (!status.isOK()) {
                message = status.getMessage();
            }
        }
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    public String getTagName() {
        return this.tagName;
    }

    public ITagOperation getOperation() {
        this.operation.setTag(new CVSTag(this.tagName, 2));
        if (this.moveTag) {
            this.operation.moveTag();
        }
        return this.operation;
    }

    static /* synthetic */ ICVSFolder access$5(TagAsVersionDialog tagAsVersionDialog) {
        return tagAsVersionDialog.folder;
    }
}

