/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.PackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionRange;

class StateWriter {
    protected Map objectTable = new HashMap();
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;

    StateWriter() {
    }

    private int addToObjectTable(Object object) {
        this.objectTable.put(object, new Integer(this.objectTable.size()));
        return this.objectTable.size() - 1;
    }

    private int getFromObjectTable(Object object) {
        Object objectResult;
        if (this.objectTable != null && (objectResult = this.objectTable.get(object)) != null) {
            return (Integer)objectResult;
        }
        return -1;
    }

    private boolean writePrefix(Object object, DataOutputStream out) throws IOException {
        if (this.writeIndex(object, out)) {
            return true;
        }
        this.addToObjectTable(object);
        out.writeByte(1);
        return false;
    }

    private void writeState(StateImpl state, DataOutputStream out) throws IOException {
        out.write(7);
        if (this.writePrefix(state, out)) {
            return;
        }
        out.writeLong(state.getTimeStamp());
        BundleDescription[] bundles = state.getBundles();
        out.writeInt(bundles.length);
        if (bundles.length == 0) {
            return;
        }
        int i = 0;
        while (i < bundles.length) {
            this.writeBundleDescription((BundleDescriptionImpl)bundles[i], out);
            ++i;
        }
        out.writeBoolean(state.isResolved());
        if (!state.isResolved()) {
            return;
        }
        BundleDescription[] resolvedBundles = state.getResolvedBundles();
        out.writeInt(resolvedBundles.length);
        int i2 = 0;
        while (i2 < resolvedBundles.length) {
            this.writeBundleDescription((BundleDescriptionImpl)resolvedBundles[i2], out);
            ++i2;
        }
    }

    private void writeBundleDescription(BundleDescriptionImpl bundle, DataOutputStream out) throws IOException {
        if (this.writePrefix(bundle, out)) {
            return;
        }
        out.writeLong(bundle.getBundleId());
        this.writeStringOrNull(bundle.getSymbolicName(), out);
        this.writeStringOrNull(bundle.getLocation(), out);
        out.writeInt(bundle.getState());
        this.writeVersion(bundle.getVersion(), out);
        this.writeHostSpec((HostSpecificationImpl)bundle.getHost(), out);
        PackageSpecification[] packages = bundle.getPackages();
        out.writeInt(packages.length);
        int i = 0;
        while (i < packages.length) {
            this.writePackageSpec((PackageSpecificationImpl)packages[i], out);
            ++i;
        }
        String[] providedPackages = bundle.getProvidedPackages();
        out.writeInt(providedPackages.length);
        int i2 = 0;
        while (i2 < providedPackages.length) {
            out.writeUTF(providedPackages[i2]);
            ++i2;
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        out.writeInt(requiredBundles.length);
        int i3 = 0;
        while (i3 < requiredBundles.length) {
            this.writeBundleSpec((BundleSpecificationImpl)requiredBundles[i3], out);
            ++i3;
        }
        out.writeBoolean(bundle.isSingleton());
    }

    private void writeBundleSpec(BundleSpecificationImpl bundle, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(bundle, out);
        out.writeBoolean(bundle.isExported());
        out.writeBoolean(bundle.isOptional());
    }

    private void writePackageSpec(PackageSpecificationImpl packageSpec, DataOutputStream out) throws IOException {
        this.writeVersionConstraint(packageSpec, out);
        out.writeBoolean(packageSpec.isExported());
    }

    private void writeHostSpec(HostSpecificationImpl host, DataOutputStream out) throws IOException {
        if (host == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(1);
        this.writeVersionConstraint(host, out);
        out.writeBoolean(host.reloadHost());
    }

    private void writeVersionConstraint(VersionConstraintImpl version, DataOutputStream out) throws IOException {
        this.writeStringOrNull(version.getName(), out);
        this.writeVersionRange(version.getVersionRange(), out);
        this.writeVersion(version.getActualVersion(), out);
        this.writeBundleDescription((BundleDescriptionImpl)version.getSupplier(), out);
    }

    private void writeVersion(Version version, DataOutputStream out) throws IOException {
        if (this.writePrefix(version, out)) {
            return;
        }
        out.writeInt(version.getMajorComponent());
        out.writeInt(version.getMinorComponent());
        out.writeInt(version.getMicroComponent());
        this.writeStringOrNull(version.getQualifierComponent(), out);
        out.writeBoolean(version.isInclusive());
    }

    private void writeVersionRange(VersionRange versionRange, DataOutputStream out) throws IOException {
        this.writeVersion(versionRange.getMinimum(), out);
        this.writeVersion(versionRange.getMaximum(), out);
    }

    private boolean writeIndex(Object object, DataOutputStream out) throws IOException {
        if (object == null) {
            out.writeByte(0);
            return true;
        }
        int index = this.getFromObjectTable(object);
        if (index == -1) {
            return false;
        }
        out.writeByte(2);
        out.writeInt(index);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState(StateImpl state, DataOutputStream output) throws IOException {
        try {
            this.writeState(state, output);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            output.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        output.close();
    }

    private void writeStringOrNull(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }
}

