/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.filebuffers.IPersistableAnnotationModel;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.internal.filebuffers.ContainerGenerator;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.ResourceFileBuffer;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.IAnnotationModel;

public class ResourceTextFileBuffer
extends ResourceFileBuffer
implements ITextFileBuffer {
    private static final int READER_CHUNK_SIZE = 2048;
    private static final int BUFFER_SIZE = 16384;
    private static final QualifiedName ENCODING_KEY = new QualifiedName("org.eclipse.core.filebuffers", "encoding");
    private static final IStatus STATUS_OK = new Status(0, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("FileBuffer.status.ok"), null);
    private static final IStatus STATUS_ERROR = new Status(4, "org.eclipse.core.filebuffers", 1, FileBuffersMessages.getString("FileBuffer.status.error"), null);
    private static final String CHARSET_UTF_8 = "UTF-8";
    protected IDocument fDocument;
    protected String fEncoding;
    protected IDocumentListener fDocumentListener = new DocumentListener();
    protected IAnnotationModel fAnnotationModel;
    private String fExplicitEncoding;
    private boolean fHasBOM;

    public ResourceTextFileBuffer(TextFileBufferManager manager) {
        super(manager);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.fAnnotationModel;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
        this.fExplicitEncoding = encoding;
        this.fHasBOM = false;
        try {
            this.fFile.setCharset(encoding);
            if (encoding == null) {
                this.fEncoding = this.fFile.getCharset();
            }
            this.setHasBOM();
        }
        catch (CoreException x) {
            this.handleCoreException(x);
        }
    }

    public IStatus getStatus() {
        if (!this.isDisposed()) {
            if (this.fStatus != null) {
                return this.fStatus;
            }
            return this.fDocument == null ? STATUS_ERROR : STATUS_OK;
        }
        return STATUS_ERROR;
    }

    public void revert(IProgressMonitor monitor) throws CoreException {
        if (this.isDisposed()) {
            return;
        }
        this.refreshFile(monitor);
        IDocument original = null;
        IStatus status = null;
        try {
            original = this.fManager.createEmptyDocument(this.fFile.getLocation());
            this.setDocumentContent(original, this.fFile.getContents(), this.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        this.fStatus = status;
        if (original != null) {
            boolean replaceContents;
            String originalContents = original.get();
            boolean bl = replaceContents = !originalContents.equals(this.fDocument.get());
            if (replaceContents) {
                this.fManager.fireBufferContentAboutToBeReplaced(this);
                this.fDocument.set(original.get());
            }
            if (this.fCanBeSaved) {
                this.fCanBeSaved = false;
                this.addFileBufferContentListeners();
            }
            if (replaceContents) {
                this.fManager.fireBufferContentReplaced(this);
            }
            if (this.fAnnotationModel instanceof IPersistableAnnotationModel) {
                IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
                persistableModel.revert(this.fDocument);
            }
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    protected void addFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.addDocumentListener(this.fDocumentListener);
        }
    }

    protected void removeFileBufferContentListeners() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
    }

    protected void initializeFileBufferContent(IProgressMonitor monitor) throws CoreException {
        try {
            this.fEncoding = null;
            this.fExplicitEncoding = null;
            try {
                this.fEncoding = this.fFile.getPersistentProperty(ENCODING_KEY);
            }
            catch (CoreException coreException) {}
            if (this.fEncoding != null) {
                try {
                    this.fExplicitEncoding = this.fEncoding;
                    this.fFile.setCharset(this.fEncoding);
                    this.fFile.setPersistentProperty(ENCODING_KEY, null);
                }
                catch (CoreException ex) {
                    this.handleCoreException(ex);
                }
            } else {
                this.fExplicitEncoding = this.fFile.getCharset(false);
                this.fEncoding = this.fExplicitEncoding != null ? this.fExplicitEncoding : this.fFile.getCharset();
            }
            this.setHasBOM();
            this.fDocument = this.fManager.createEmptyDocument(this.fFile.getLocation());
            this.setDocumentContent(this.fDocument, this.fFile.getContents(), this.fEncoding);
            this.fAnnotationModel = this.fManager.createAnnotationModel(this.fFile.getLocation());
        }
        catch (CoreException x) {
            this.fDocument = this.fManager.createEmptyDocument(this.fFile.getLocation());
            this.fStatus = x.getStatus();
        }
    }

    protected void setHasBOM() throws CoreException {
        this.fHasBOM = false;
        IContentDescription description = this.fFile.getContentDescription();
        this.fHasBOM = description != null && description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null;
    }

    protected void connected() {
        super.connected();
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.connect(this.fDocument);
        }
    }

    protected void disconnected() {
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.disconnect(this.fDocument);
        }
        super.disconnected();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitFileBufferContent(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        String encoding = this.computeEncoding();
        try {
            byte[] bytes = this.fDocument.get().getBytes(encoding);
            if (this.fHasBOM && CHARSET_UTF_8.equals(encoding)) {
                int bomLength = IContentDescription.BOM_UTF_8.length;
                byte[] bytesWithBOM = new byte[bytes.length + bomLength];
                System.arraycopy(IContentDescription.BOM_UTF_8, 0, bytesWithBOM, 0, bomLength);
                System.arraycopy(bytes, 0, bytesWithBOM, bomLength, bytes.length);
                bytes = bytesWithBOM;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            if (this.fFile.exists()) {
                if (!overwrite) {
                    this.checkSynchronizationState();
                }
                this.fFile.setContents((InputStream)stream, overwrite, true, monitor);
                this.fSynchronizationStamp = this.fFile.getModificationStamp();
                if (!(this.fAnnotationModel instanceof IPersistableAnnotationModel)) return;
                IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
                persistableModel.commit(this.fDocument);
                return;
            }
            try {
                monitor.beginTask("Saving", 2000);
                ContainerGenerator generator = new ContainerGenerator(this.fFile.getWorkspace(), this.fFile.getParent().getFullPath());
                generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                this.fFile.create((InputStream)stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var7_13 = null;
                monitor.done();
                return;
            }
        }
        catch (UnsupportedEncodingException x) {
            String message = FileBuffersMessages.getFormattedString("ResourceTextFileBuffer.error.unsupported_encoding.message_arg", encoding);
            Status s = new Status(4, "org.eclipse.core.filebuffers", 0, message, (Throwable)x);
            throw new CoreException((IStatus)s);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeEncoding() {
        block18: {
            block16: {
                if (this.fExplicitEncoding != null) {
                    return this.fExplicitEncoding;
                }
                try {
                    this.fExplicitEncoding = this.fFile.getCharset(false);
                    if (this.fExplicitEncoding != null) {
                        return this.fExplicitEncoding;
                    }
                }
                catch (CoreException v0) {}
                reader = new BufferedReader(new StringReader(this.fDocument.get()));
                try {
                    try {
                        options = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
                        description = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, this.fFile.getName(), options);
                        if (description == null || (encoding = description.getCharset()) == null) break block16;
                        var7_5 = encoding;
                        var5_6 = null;
                    }
                    catch (IOException v1) {
                        break block16;
                    }
                }
                catch (Throwable var6_12) {
                    var5_7 = null;
                    try {
                        reader.close();
                        throw var6_12;
                    }
                    catch (IOException ex) {
                        FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
                    }
                    throw var6_12;
                }
                ** try [egrp 3[TRYBLOCK] [5 : 147->154)] { 
lbl32:
                // 1 sources

                reader.close();
                return var7_5;
lbl34:
                // 1 sources

                catch (IOException ex) {
                    FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
                }
                return var7_5;
            }
            var5_8 = null;
            ** try [egrp 3[TRYBLOCK] [5 : 147->154)] { 
lbl40:
            // 1 sources

            reader.close();
            break block18;
lbl42:
            // 1 sources

            catch (IOException ex) {
                FileBuffersPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("ResourceTextFileBuffer.error.closeReader"), (Throwable)ex));
            }
        }
        if (this.fHasBOM) {
            return this.fEncoding;
        }
        try {
            return this.fFile.getParent().getDefaultCharset();
        }
        catch (CoreException v2) {
            return this.fManager.getDefaultEncoding();
        }
    }

    protected void handleFileContentChanged() {
        if (this.isDisposed()) {
            return;
        }
        IDocument document = this.fManager.createEmptyDocument(this.fFile.getLocation());
        IStatus status = null;
        try {
            this.setDocumentContent(document, this.fFile.getContents(false), this.fEncoding);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        String newContent = document.get();
        if (!newContent.equals(this.fDocument.get())) {
            this.fManager.fireBufferContentAboutToBeReplaced(this);
            this.removeFileBufferContentListeners();
            this.fDocument.set(newContent);
            this.fCanBeSaved = false;
            this.fSynchronizationStamp = this.fFile.getModificationStamp();
            this.fStatus = status;
            this.addFileBufferContentListeners();
            this.fManager.fireBufferContentReplaced(this);
            if (this.fAnnotationModel instanceof IPersistableAnnotationModel) {
                IPersistableAnnotationModel persistableModel = (IPersistableAnnotationModel)this.fAnnotationModel;
                try {
                    persistableModel.reinitialize(this.fDocument);
                }
                catch (CoreException coreException) {
                    this.fStatus = status;
                }
            }
        } else {
            this.removeFileBufferContentListeners();
            this.fCanBeSaved = false;
            this.fSynchronizationStamp = this.fFile.getModificationStamp();
            this.fStatus = status;
            this.addFileBufferContentListeners();
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    /*
     * Exception decompiling
     */
    private void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 209->213)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkSynchronizationState() throws CoreException {
        if (!this.fFile.isSynchronized(0)) {
            Status status = new Status(4, "org.eclipse.core.filebuffers", 274, FileBuffersMessages.getString("FileBuffer.error.outOfSync"), null);
            throw new CoreException((IStatus)status);
        }
    }

    private class DocumentListener
    implements IDocumentListener {
        DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            ResourceTextFileBuffer.this.fCanBeSaved = true;
            ResourceTextFileBuffer.this.removeFileBufferContentListeners();
            ResourceTextFileBuffer.this.fManager.fireDirtyStateChanged(ResourceTextFileBuffer.this, ResourceTextFileBuffer.this.fCanBeSaved);
        }
    }
}

