/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.hcr;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.debug.core.hcr.Differencer;
import org.eclipse.jdt.internal.debug.core.hcr.JavaNode;
import org.eclipse.jdt.internal.debug.core.hcr.JavaParseTreeBuilder;

public class CompilationUnitDelta {
    private static final boolean DEBUG = false;
    private SimpleJavaElement fRoot;
    private boolean fHasHistory = false;

    public CompilationUnitDelta(org.eclipse.jdt.core.ICompilationUnit cu, long timestamp) throws CoreException {
        IFile file;
        IFileState[] states;
        if (cu.isWorkingCopy()) {
            cu = cu.getPrimary();
        }
        if ((states = (file = (IFile)cu.getUnderlyingResource()).getHistory(null)) == null || states.length <= 0) {
            return;
        }
        this.fHasHistory = true;
        IFileState found = null;
        int i = 0;
        while (i < states.length) {
            IFileState state = states[i];
            long d = state.getModificationTime();
            if (d < timestamp) {
                found = state;
                break;
            }
            ++i;
        }
        if (found == null) {
            found = states[states.length - 1];
        }
        InputStream oldContents = null;
        InputStream newContents = null;
        try {
            oldContents = found.getContents();
            newContents = file.getContents();
        }
        catch (CoreException coreException) {
            return;
        }
        JavaNode oldStructure = CompilationUnitDelta.parse(oldContents);
        JavaNode newStructure = CompilationUnitDelta.parse(newContents);
        final boolean[] memberDeleted = new boolean[1];
        Differencer differencer = new Differencer(){

            protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                String name = null;
                switch (result) {
                    case 3: {
                        name = ((JavaNode)left).getId();
                        break;
                    }
                    case 1: {
                        name = ((JavaNode)right).getId();
                        break;
                    }
                    case 2: {
                        name = ((JavaNode)left).getId();
                        memberDeleted[0] = true;
                        break;
                    }
                }
                if (name != null) {
                    return new SimpleJavaElement((SimpleJavaElement)data, name);
                }
                return null;
            }

            protected boolean contentsEqual(Object o1, Object o2) {
                String s1 = ((JavaNode)o1).getContents();
                String s2 = ((JavaNode)o2).getContents();
                return s1.equals(s2);
            }

            protected Object[] getChildren(Object input) {
                if (input instanceof JavaNode) {
                    return ((JavaNode)input).getChildren();
                }
                return null;
            }
        };
        this.fRoot = (SimpleJavaElement)differencer.findDifferences(false, null, null, null, oldStructure, newStructure);
        boolean bl = this.fHasHistory = this.fRoot != null;
        if (memberDeleted[0]) {
            this.fRoot = null;
        }
    }

    public boolean hasChanged(IMember member) {
        org.eclipse.jdt.core.ICompilationUnit cu = member.getCompilationUnit();
        if (cu.isWorkingCopy()) {
            cu = cu.getPrimary();
        }
        if (this.fRoot == null) {
            return this.fHasHistory;
        }
        String[] path = CompilationUnitDelta.createPath((IJavaElement)member);
        return this.fRoot.find(path, 0);
    }

    private static JavaNode parse(InputStream input) {
        char[] buffer = CompilationUnitDelta.readString(input);
        if (buffer != null) {
            JavaNode root = new JavaNode(buffer);
            JavaParseTreeBuilder builder = new JavaParseTreeBuilder(root, buffer);
            SourceElementParser parser = new SourceElementParser((ISourceElementRequestor)builder, (IProblemFactory)new ProblemFactory(), new CompilerOptions((Map)JavaCore.getOptions()));
            try {
                parser.parseCompilationUnit((ICompilationUnit)builder, false);
            }
            catch (ParseError parseError) {
                return null;
            }
            return root;
        }
        return null;
    }

    private static String[] createPath(IJavaElement je) {
        ArrayList<String> args = new ArrayList<String>();
        while (je != null) {
            String name = CompilationUnitDelta.getJavaElementID(je);
            if (name == null) {
                return null;
            }
            args.add(name);
            if (je instanceof org.eclipse.jdt.core.ICompilationUnit) break;
            je = je.getParent();
        }
        int n = args.size();
        String[] path = new String[n];
        int i = 0;
        while (i < n) {
            path[i] = (String)args.get(n - 1 - i);
            ++i;
        }
        return path;
    }

    private static String getJavaElementID(IJavaElement je) {
        if (je instanceof IMember && ((IMember)je).isBinary()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        switch (je.getElementType()) {
            case 5: {
                sb.append('{');
                break;
            }
            case 7: {
                sb.append('[');
                sb.append(je.getElementName());
                break;
            }
            case 8: {
                sb.append('^');
                sb.append(je.getElementName());
                break;
            }
            case 9: {
                sb.append('~');
                IMethod method = (IMethod)je;
                sb.append(method.getElementName());
                sb.append('(');
                String[] types = method.getParameterTypes();
                int nParams = types != null ? types.length : 0;
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    if (types != null) {
                        sb.append(CompilationUnitDelta.unqualifyName(Signature.getSimpleName((String)Signature.toString((String)types[i]))));
                    }
                    ++i;
                }
                sb.append(')');
                break;
            }
            case 10: {
                String id = je.getHandleIdentifier();
                int pos = id.lastIndexOf(124);
                if (pos < 0) break;
                sb.append(id.substring(pos));
                break;
            }
            case 11: {
                sb.append('%');
                break;
            }
            case 12: {
                sb.append('<');
                break;
            }
            case 13: {
                sb.append('#');
                sb.append(je.getElementName());
                break;
            }
            default: {
                return null;
            }
        }
        return sb.toString();
    }

    private static String unqualifyName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(47);
        if (index > -1) {
            return qualifiedName.substring(index + 1);
        }
        return qualifiedName;
    }

    /*
     * Exception decompiling
     */
    private static char[] readString(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 125->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class SimpleJavaElement {
        private String fName;
        private HashMap fChildren;

        SimpleJavaElement(SimpleJavaElement parent, String name) {
            this.fName = name;
            if (parent != null) {
                if (parent.fChildren == null) {
                    parent.fChildren = new HashMap();
                }
                parent.fChildren.put(name, this);
            }
        }

        void dump(int level) {
            int i = 0;
            while (i < level) {
                System.out.print("  ");
                ++i;
            }
            System.out.println(this.fName);
            if (this.fChildren != null) {
                Iterator iter = this.fChildren.values().iterator();
                while (iter.hasNext()) {
                    SimpleJavaElement e = (SimpleJavaElement)iter.next();
                    e.dump(level + 1);
                }
            }
        }

        boolean find(String[] path, int start) {
            SimpleJavaElement child;
            if (start >= path.length) {
                return true;
            }
            String key = path[start];
            if (this.fChildren != null && (child = (SimpleJavaElement)this.fChildren.get(key)) != null) {
                return child.find(path, start + 1);
            }
            return false;
        }
    }

    private static class ParseError
    extends Error {
        ParseError() {
        }
    }

    private static class ProblemFactory
    implements IProblemFactory {
        ProblemFactory() {
        }

        public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
            if ((severity & 1) > 0) {
                throw new ParseError();
            }
            return null;
        }

        public Locale getLocale() {
            return Locale.getDefault();
        }

        public String getLocalizedMessage(int problemId, String[] problemArguments) {
            return "" + problemId;
        }
    }
}

