/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.hcr;

import com.sun.jdi.ReferenceType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.core.ListenerList;
import org.eclipse.jdi.hcr.VirtualMachine;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ISourceAttribute;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.hcr.CompilationUnitDelta;
import org.eclipse.jdt.internal.debug.core.hcr.JDIDebugHCRMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class JavaHotCodeReplaceManager
implements IResourceChangeListener,
ILaunchListener,
IDebugEventSetListener {
    private static JavaHotCodeReplaceManager fgInstance = null;
    private static final String CLASS_FILE_EXTENSION = "class";
    private ListenerList fHotCodeReplaceListeners = new ListenerList(1);
    private ArrayList fHotSwapTargets = new ArrayList(1);
    private ArrayList fNoHotSwapTargets = new ArrayList(1);
    private Map fProjectBuildTimes = new HashMap();
    private static Date fStartupDate = new Date();
    protected BuiltProjectVisitor fProjectVisitor = new BuiltProjectVisitor();
    protected ChangedClassFilesVisitor fClassfileVisitor = new ChangedClassFilesVisitor();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private JavaHotCodeReplaceManager() {
    }

    public static synchronized JavaHotCodeReplaceManager getDefault() {
        if (fgInstance == null) {
            fgInstance = new JavaHotCodeReplaceManager();
        }
        return fgInstance;
    }

    public void startup() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.fHotCodeReplaceListeners.removeAll();
        this.fHotSwapTargets = null;
        this.fNoHotSwapTargets = null;
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        ChangedClassFilesVisitor visitor;
        List projects = this.getBuiltProjects(event);
        if (!projects.isEmpty()) {
            this.updateProjectBuildTime(projects);
        }
        if ((visitor = this.getChangedClassFiles(event)) != null) {
            List resources = visitor.getChangedClassFiles();
            List names = visitor.getQualifiedNamesList();
            if (!resources.isEmpty()) {
                this.notifyTargets(resources, names);
            }
        }
    }

    protected List getBuiltProjects(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (event.getType() != 16 || delta == null) {
            return Collections.EMPTY_LIST;
        }
        this.fProjectVisitor.reset();
        try {
            delta.accept((IResourceDeltaVisitor)this.fProjectVisitor);
        }
        catch (CoreException e) {
            JDIDebugPlugin.log(e);
            return Collections.EMPTY_LIST;
        }
        return this.fProjectVisitor.getBuiltProjects();
    }

    private void updateProjectBuildTime(List projects) {
        Iterator iter = projects.iterator();
        IProject project = null;
        Date currentDate = new Date();
        ProjectBuildTime buildTime = null;
        while (iter.hasNext()) {
            project = (IProject)iter.next();
            buildTime = (ProjectBuildTime)this.fProjectBuildTimes.get(project);
            if (buildTime == null) {
                buildTime = new ProjectBuildTime();
                this.fProjectBuildTimes.put(project, buildTime);
            }
            buildTime.setCurrentBuildDate(currentDate);
        }
    }

    protected long getLastProjectBuildTime(IProject project) {
        ProjectBuildTime time = (ProjectBuildTime)this.fProjectBuildTimes.get(project);
        if (time == null) {
            time = new ProjectBuildTime();
            time.setLastBuildDate(fStartupDate);
            this.fProjectBuildTimes.put(project, time);
        }
        return time.getLastBuildDate().getTime();
    }

    private void notifyTargets(final List resources, final List qualifiedNames) {
        Runnable runnable;
        final List hotSwapTargets = this.getHotSwapTargets();
        final List noHotSwapTargets = this.getNoHotSwapTargets();
        if (!hotSwapTargets.isEmpty()) {
            runnable = new Runnable(){

                public void run() {
                    JavaHotCodeReplaceManager.this.doHotCodeReplace(hotSwapTargets, resources, qualifiedNames);
                }
            };
            DebugPlugin.getDefault().asyncExec(runnable);
        }
        if (!noHotSwapTargets.isEmpty()) {
            runnable = new Runnable(){

                public void run() {
                    JavaHotCodeReplaceManager.this.notifyUnsupportedHCR(noHotSwapTargets, qualifiedNames);
                }
            };
            DebugPlugin.getDefault().asyncExec(runnable);
        }
    }

    protected void notifyUnsupportedHCR(List targets, List qualifiedNames) {
        Iterator iter = targets.iterator();
        JDIDebugTarget target = null;
        while (iter.hasNext()) {
            target = (JDIDebugTarget)iter.next();
            this.fireHCRFailed(target, null);
            this.notifyFailedHCR(target, qualifiedNames);
        }
    }

    protected void notifyFailedHCR(JDIDebugTarget target, List qualifiedNames) {
        if (target.isAvailable()) {
            target.addOutOfSynchTypes(qualifiedNames);
            target.fireChangeEvent(256);
        }
    }

    protected List getHotSwapTargets() {
        return (List)this.fHotSwapTargets.clone();
    }

    protected List getNoHotSwapTargets() {
        return (List)this.fNoHotSwapTargets.clone();
    }

    private void doHotCodeReplace(List targets, List resources, List qualifiedNames) {
        MultiStatus ms = new MultiStatus(JDIDebugPlugin.getUniqueIdentifier(), 5010, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.drop_to_frame_failed"), null);
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            JDIDebugTarget target = (JDIDebugTarget)iter.next();
            if (!target.isAvailable()) continue;
            ArrayList poppedThreads = new ArrayList();
            target.setIsPerformingHotCodeReplace(true);
            try {
                boolean framesPopped = false;
                if (target.canPopFrames()) {
                    try {
                        this.attemptPopFrames(target, resources, qualifiedNames, poppedThreads);
                        framesPopped = true;
                    }
                    catch (DebugException de) {
                        ms.merge(de.getStatus());
                    }
                }
                target.removeOutOfSynchTypes(qualifiedNames);
                if (target.supportsJDKHotCodeReplace()) {
                    this.redefineTypesJDK(target, resources, qualifiedNames);
                } else if (target.supportsJ9HotCodeReplace()) {
                    this.redefineTypesJ9(target, qualifiedNames);
                }
                if (this.containsObsoleteMethods(target)) {
                    this.fireObsoleteMethods(target);
                }
                if (target.canPopFrames() && framesPopped) {
                    try {
                        target.setIsPerformingHotCodeReplace(false);
                        this.attemptStepIn(poppedThreads);
                    }
                    catch (DebugException de) {
                        ms.merge(de.getStatus());
                    }
                } else {
                    this.attemptDropToFrame(target, resources, qualifiedNames);
                }
                this.fireHCRSucceeded(target);
            }
            catch (DebugException de) {
                this.fireHCRFailed(target, de);
            }
            target.setIsPerformingHotCodeReplace(false);
            target.fireChangeEvent(512);
        }
        if (!ms.isOK()) {
            JDIDebugPlugin.log((IStatus)ms);
        }
    }

    private void redefineTypesJ9(JDIDebugTarget target, List qualifiedNames) throws DebugException {
        String[] typeNames = qualifiedNames.toArray(new String[qualifiedNames.size()]);
        if (target.supportsJ9HotCodeReplace()) {
            target.setHCROccurred(true);
            VirtualMachine vm = (VirtualMachine)((Object)target.getVM());
            if (vm == null) {
                target.requestFailed(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.Hot_code_replace_failed_-_VM_disconnected._1"), null);
            }
            int result = 1;
            try {
                result = vm.classesHaveChanged(typeNames);
            }
            catch (RuntimeException e) {
                target.targetRequestFailed(MessageFormat.format(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.exception_replacing_types"), e.toString()), e);
            }
            switch (result) {
                case 0: {
                    break;
                }
                case 2: {
                    target.targetRequestFailed(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_ignored"), null);
                    break;
                }
                case 1: {
                    target.targetRequestFailed(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_failed"), null);
                    target.addOutOfSynchTypes(qualifiedNames);
                }
            }
        } else {
            target.notSupported(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.does_not_support_hcr"));
            target.addOutOfSynchTypes(qualifiedNames);
        }
    }

    private void redefineTypesJDK(JDIDebugTarget target, List resources, List qualifiedNames) throws DebugException {
        if (target.supportsJDKHotCodeReplace()) {
            target.setHCROccurred(true);
            Map typesToBytes = this.getTypesToBytes(target, resources, qualifiedNames);
            try {
                com.sun.jdi.VirtualMachine vm = target.getVM();
                if (vm == null) {
                    target.requestFailed(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.Hot_code_replace_failed_-_VM_disconnected._2"), null);
                }
                vm.redefineClasses(typesToBytes);
            }
            catch (UnsupportedOperationException exception) {
                String detail = exception.getMessage();
                if (detail != null) {
                    this.redefineTypesFailedJDK(target, qualifiedNames, MessageFormat.format(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_unsupported_operation"), detail), exception);
                } else {
                    this.redefineTypesFailedJDK(target, qualifiedNames, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_unsupported_redefinition"), exception);
                }
            }
            catch (NoClassDefFoundError exception) {
                this.redefineTypesFailedJDK(target, qualifiedNames, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_bad_bytes"), exception);
            }
            catch (VerifyError exception) {
                this.redefineTypesFailedJDK(target, qualifiedNames, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_verify_error"), exception);
            }
            catch (UnsupportedClassVersionError exception) {
                this.redefineTypesFailedJDK(target, qualifiedNames, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_unsupported_class_version"), exception);
            }
            catch (ClassFormatError exception) {
                this.redefineTypesFailedJDK(target, qualifiedNames, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_class_format_error"), exception);
            }
            catch (ClassCircularityError exception) {
                this.redefineTypesFailedJDK(target, qualifiedNames, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_class_circularity_error"), exception);
            }
            catch (RuntimeException exception) {
                this.redefineTypesFailedJDK(target, qualifiedNames, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.hcr_failed"), exception);
            }
            target.reinstallBreakpointsIn(resources, qualifiedNames);
        } else {
            target.notSupported(JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.does_not_support_hcr"));
        }
    }

    private void redefineTypesFailedJDK(JDIDebugTarget target, List qualifiedNames, String message, Throwable exception) throws DebugException {
        target.addOutOfSynchTypes(qualifiedNames);
        target.jdiRequestFailed(message, exception);
    }

    private Map getTypesToBytes(JDIDebugTarget target, List resources, List qualifiedNames) {
        HashMap<ReferenceType, byte[]> typesToBytes = new HashMap<ReferenceType, byte[]>(resources.size());
        Iterator resourceIter = resources.iterator();
        Iterator nameIter = qualifiedNames.iterator();
        while (resourceIter.hasNext()) {
            IResource resource = (IResource)resourceIter.next();
            String name = (String)nameIter.next();
            List classes = target.jdiClassesByName(name);
            byte[] bytes = null;
            try {
                bytes = Util.getResourceContentsAsByteArray((IFile)((IFile)resource));
            }
            catch (JavaModelException javaModelException) {
                continue;
            }
            Iterator classIter = classes.iterator();
            while (classIter.hasNext()) {
                ReferenceType type = (ReferenceType)classIter.next();
                typesToBytes.put(type, bytes);
            }
        }
        return typesToBytes;
    }

    private void fireHCRSucceeded(IJavaDebugTarget target) {
        Object[] listeners = this.fHotCodeReplaceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IJavaHotCodeReplaceListener)listeners[i]).hotCodeReplaceSucceeded(target);
            ++i;
        }
    }

    private void fireHCRFailed(JDIDebugTarget target, DebugException exception) {
        Object[] listeners = this.fHotCodeReplaceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IJavaHotCodeReplaceListener)listeners[i]).hotCodeReplaceFailed(target, exception);
            ++i;
        }
    }

    private void fireObsoleteMethods(JDIDebugTarget target) {
        Object[] listeners = this.fHotCodeReplaceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IJavaHotCodeReplaceListener)listeners[i]).obsoleteMethods(target);
            ++i;
        }
    }

    protected void attemptDropToFrame(JDIDebugTarget target, List resources, List replacedClassNames) throws DebugException {
        List dropFrames = this.getAffectedFrames(target.getThreads(), resources, replacedClassNames);
        JDIStackFrame dropFrame = null;
        Iterator iter = dropFrames.iterator();
        while (iter.hasNext()) {
            try {
                dropFrame = (JDIStackFrame)iter.next();
                dropFrame.dropToFrame();
            }
            catch (DebugException debugException) {
                this.notifyFailedDrop(((JDIThread)dropFrame.getThread()).computeStackFrames(), replacedClassNames);
            }
        }
    }

    protected void attemptPopFrames(JDIDebugTarget target, List resources, List replacedClassNames, List poppedThreads) throws DebugException {
        List popFrames = this.getAffectedFrames(target.getThreads(), resources, replacedClassNames);
        JDIStackFrame popFrame = null;
        Iterator iter = popFrames.iterator();
        while (iter.hasNext()) {
            try {
                popFrame = (JDIStackFrame)iter.next();
                popFrame.popFrame();
                poppedThreads.add(popFrame.getThread());
            }
            catch (DebugException debugException) {
                poppedThreads.remove(popFrame.getThread());
                this.notifyFailedDrop(((JDIThread)popFrame.getThread()).computeStackFrames(), replacedClassNames);
            }
        }
    }

    protected boolean containsObsoleteMethods(JDIDebugTarget target) throws DebugException {
        IThread[] threads = target.getThreads();
        List frames = null;
        Iterator iter = null;
        int i = 0;
        int numThreads = threads.length;
        while (i < numThreads) {
            frames = ((JDIThread)threads[i]).computeNewStackFrames();
            iter = frames.iterator();
            while (iter.hasNext()) {
                if (!((JDIStackFrame)iter.next()).isObsolete()) continue;
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List getAffectedFrames(IThread[] threads, List resourceList, List replacedClassNames) throws DebugException {
        JDIThread thread = null;
        JDIStackFrame affectedFrame = null;
        ArrayList<JDIStackFrame> popFrames = new ArrayList<JDIStackFrame>();
        int numThreads = threads.length;
        IResource[] resources = new IResource[resourceList.size()];
        resourceList.toArray(resources);
        int i = 0;
        while (i < numThreads) {
            thread = (JDIThread)threads[i];
            if (thread.isSuspended() && (affectedFrame = this.getAffectedFrame(thread, replacedClassNames)) != null) {
                if (affectedFrame.supportsDropToFrame()) {
                    popFrames.add(affectedFrame);
                } else {
                    int j = 0;
                    while (j < numThreads) {
                        this.notifyFailedDrop(((JDIThread)threads[i]).computeStackFrames(), replacedClassNames);
                        ++j;
                    }
                    throw new DebugException((IStatus)new Status(4, JDIDebugModel.getPluginIdentifier(), 5011, JDIDebugHCRMessages.getString("JavaHotCodeReplaceManager.Drop_to_frame_not_supported"), null));
                }
            }
            ++i;
        }
        return popFrames;
    }

    /*
     * Unable to fully structure code
     */
    protected JDIStackFrame getAffectedFrame(JDIThread thread, List replacedClassNames) throws DebugException {
        frames = thread.computeStackFrames();
        affectedFrame = null;
        frame = null;
        compilationUnit = null;
        method = null;
        delta = null;
        project = null;
        j = frames.size() - 1;
        block2: while (j >= 0) {
            block5: {
                block4: {
                    frame = (JDIStackFrame)frames.get(j);
                    if (!this.containsChangedType(frame, replacedClassNames) || (compilationUnit = this.getCompilationUnit(frame)) == null) break block5;
                    try {
                        project = compilationUnit.getCorrespondingResource().getProject();
                        method = this.getMethod(frame, compilationUnit);
                        if (method == null || (delta = new CompilationUnitDelta(compilationUnit, this.getLastProjectBuildTime(project))).hasChanged((IMember)method)) break block4;
                        break block5;
                    }
                    catch (CoreException v0) {}
                }
                if (!frame.supportsDropToFrame()) ** GOTO lbl25
                affectedFrame = frame;
                break;
lbl-1000:
                // 1 sources

                {
                    if (!(frame = (JDIStackFrame)frames.get(--j)).supportsDropToFrame()) continue;
                    affectedFrame = frame;
                    break block2;
lbl25:
                    // 2 sources

                    ** while (j > 0)
                }
lbl26:
                // 1 sources

                break;
            }
            --j;
        }
        return affectedFrame;
    }

    protected boolean containsChangedType(JDIStackFrame frame, List replacedClassNames) throws DebugException {
        String declaringTypeName = frame.getDeclaringTypeName();
        if (replacedClassNames.contains(declaringTypeName)) {
            return true;
        }
        Iterator iter = replacedClassNames.iterator();
        String className = null;
        while (iter.hasNext()) {
            className = (String)iter.next();
            int index = className.indexOf(36);
            if (index <= -1 || !declaringTypeName.equals(className.substring(0, index))) continue;
            return true;
        }
        return false;
    }

    protected void attemptStepIn(List threads) throws DebugException {
        Iterator iter = threads.iterator();
        while (iter.hasNext()) {
            ((JDIThread)iter.next()).stepInto();
        }
    }

    protected ICompilationUnit getCompilationUnit(IJavaStackFrame frame) {
        ILaunch launch = frame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement((IStackFrame)frame);
        if (!(sourceElement instanceof IJavaElement) && sourceElement instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)sourceElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sourceElement = iAdaptable.getAdapter((Class)clazz);
        }
        if (sourceElement instanceof IType) {
            return ((IType)sourceElement).getCompilationUnit();
        }
        if (sourceElement instanceof ICompilationUnit) {
            return (ICompilationUnit)sourceElement;
        }
        return null;
    }

    public IMethod getMethod(JDIStackFrame frame, ICompilationUnit unit) throws CoreException {
        String declaringTypeName = frame.getDeclaringTypeName();
        String methodName = frame.getMethodName();
        String[] arguments = null;
        try {
            arguments = Signature.getParameterTypes((String)frame.getSignature());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        String typeName = this.getUnqualifiedName(declaringTypeName);
        int index = typeName.indexOf(36);
        IType type = null;
        if (index > 0) {
            String remaining = typeName.substring(index + 1);
            typeName = typeName.substring(0, index);
            type = unit.getType(typeName);
            while (remaining != null) {
                index = remaining.indexOf(36);
                if (index > 0) {
                    typeName = remaining.substring(0, index);
                    remaining = remaining.substring(index + 1);
                } else {
                    typeName = remaining;
                    remaining = null;
                }
                type = type.getType(typeName);
            }
        } else {
            type = unit.getType(typeName);
        }
        if (type != null) {
            return type.getMethod(methodName, arguments);
        }
        return null;
    }

    protected String getUnqualifiedName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(46);
        return qualifiedName.substring(index + 1);
    }

    private void notifyFailedDrop(List frames, List replacedClassNames) throws DebugException {
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            JDIStackFrame frame = (JDIStackFrame)iter.next();
            if (!replacedClassNames.contains(frame.getDeclaringTypeName())) continue;
            frame.setOutOfSynch(true);
        }
    }

    protected ChangedClassFilesVisitor getChangedClassFiles(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (event.getType() != 1 || delta == null) {
            return null;
        }
        this.fClassfileVisitor.reset();
        try {
            delta.accept((IResourceDeltaVisitor)this.fClassfileVisitor);
        }
        catch (CoreException e) {
            JDIDebugPlugin.log(e);
            return null;
        }
        return this.fClassfileVisitor;
    }

    public void addHotCodeReplaceListener(IJavaHotCodeReplaceListener listener) {
        this.fHotCodeReplaceListeners.add((Object)listener);
    }

    public void removeHotCodeReplaceListener(IJavaHotCodeReplaceListener listener) {
        this.fHotCodeReplaceListeners.remove((Object)listener);
    }

    public void launchRemoved(ILaunch launch) {
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        int i = 0;
        while (i < debugTargets.length) {
            IJavaDebugTarget jt;
            IDebugTarget iDebugTarget = debugTargets[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jt = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null) {
                this.deregisterTarget((JDIDebugTarget)jt);
            }
            ++i;
        }
    }

    public void launchAdded(ILaunch launch) {
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        int i = 0;
        while (i < debugTargets.length) {
            IJavaDebugTarget jt;
            IDebugTarget iDebugTarget = debugTargets[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((jt = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null) {
                JDIDebugTarget target = (JDIDebugTarget)jt;
                if (target.supportsHotCodeReplace()) {
                    this.addHotSwapTarget(target);
                } else {
                    this.addNonHotSwapTarget(target);
                }
            }
            ++i;
        }
        if (!this.fHotSwapTargets.isEmpty() || !this.fNoHotSwapTargets.isEmpty()) {
            this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 17);
        }
    }

    public void launchChanged(ILaunch launch) {
        this.launchAdded(launch);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object source;
            DebugEvent event = events[i];
            if (event.getKind() == 8 && (source = event.getSource()) instanceof IAdaptable) {
                IJavaDebugTarget jt;
                IAdaptable iAdaptable = (IAdaptable)source;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((jt = (IJavaDebugTarget)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.deregisterTarget((JDIDebugTarget)jt);
                }
            }
            ++i;
        }
    }

    protected void deregisterTarget(JDIDebugTarget target) {
        if (!this.fHotSwapTargets.remove(target)) {
            this.fNoHotSwapTargets.remove(target);
        }
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            IDebugTarget[] targets = launches[i].getDebugTargets();
            int j = 0;
            while (j < targets.length) {
                IJavaDebugTarget jt;
                IDebugTarget debugTarget = targets[j];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((jt = (IJavaDebugTarget)debugTarget.getAdapter((Class)clazz)) != null && ((JDIDebugTarget)jt).isAvailable()) {
                    return;
                }
                ++j;
            }
            ++i;
        }
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void addHotSwapTarget(JDIDebugTarget target) {
        if (!this.fHotSwapTargets.contains(target)) {
            this.fHotSwapTargets.add(target);
        }
    }

    protected void addNonHotSwapTarget(JDIDebugTarget target) {
        if (!this.fNoHotSwapTargets.contains(target)) {
            this.fNoHotSwapTargets.add(target);
        }
    }

    class ProjectBuildTime {
        private Date fCurrentDate = new Date();
        private Date fPreviousDate = new Date();

        ProjectBuildTime() {
        }

        public void setCurrentBuildDate(Date date) {
            this.fPreviousDate = this.fCurrentDate;
            this.fCurrentDate = date;
        }

        public void setLastBuildDate(Date date) {
            this.fPreviousDate = date;
            if (this.fPreviousDate.getTime() > this.fCurrentDate.getTime()) {
                this.fCurrentDate = this.fPreviousDate;
            }
        }

        public Date getLastBuildDate() {
            return this.fPreviousDate;
        }
    }

    class ChangedClassFilesVisitor
    implements IResourceDeltaVisitor {
        protected List fFiles = null;
        protected List fNames = null;

        ChangedClassFilesVisitor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean visit(IResourceDelta delta) {
            if (delta == null) return false;
            if ((delta.getKind() & 4) == 0) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource == null) return true;
            switch (resource.getType()) {
                case 1: {
                    if ((delta.getFlags() & 0x100) == 0) {
                        return false;
                    }
                    if (!JavaHotCodeReplaceManager.CLASS_FILE_EXTENSION.equals(resource.getFullPath().getFileExtension())) return false;
                    IPath localLocation = resource.getLocation();
                    if (localLocation == null) return false;
                    String path = localLocation.toOSString();
                    IClassFileReader reader = ToolFactory.createDefaultClassFileReader((String)path, (int)17);
                    if (reader == null) return false;
                    String qualifiedName = new String(reader.getClassName());
                    boolean hasBlockingErrors = false;
                    try {
                        if (!JDIDebugModel.getPreferences().getBoolean(JDIDebugModel.PREF_HCR_WITH_COMPILATION_ERRORS)) {
                            IResource sourceFile;
                            IJavaProject pro = JavaCore.create((IProject)resource.getProject());
                            ISourceAttribute sourceAttribute = reader.getSourceFileAttribute();
                            String sourceName = null;
                            if (sourceAttribute != null) {
                                sourceName = new String(sourceAttribute.getSourceFileName());
                            }
                            if ((sourceFile = this.getSourceFile(pro, qualifiedName, sourceName)) != null) {
                                IMarker[] problemMarkers = null;
                                problemMarkers = sourceFile.findMarkers("org.eclipse.jdt.core.problem", true, 2);
                                int i = 0;
                                while (i < problemMarkers.length) {
                                    if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                                        return false;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    catch (CoreException e) {
                        JDIDebugPlugin.log(e);
                    }
                    if (hasBlockingErrors) return false;
                    this.fFiles.add(resource);
                    this.fNames.add(qualifiedName.replace('/', '.'));
                    return false;
                }
            }
            return true;
        }

        public void reset() {
            this.fFiles = new ArrayList();
            this.fNames = new ArrayList();
        }

        public List getChangedClassFiles() {
            return this.fFiles;
        }

        public List getQualifiedNamesList() {
            return this.fNames;
        }

        private IResource getSourceFile(IJavaProject project, String qualifiedName, String sourceAttribute) {
            String name = null;
            if (sourceAttribute == null) {
                int nestedIndex = qualifiedName.indexOf(36);
                if (nestedIndex != -1) {
                    name = qualifiedName.substring(0, nestedIndex);
                }
                name = String.valueOf(name) + ".java";
            } else {
                int i = qualifiedName.lastIndexOf(47);
                if (i > 0) {
                    name = qualifiedName.substring(0, i + 1);
                    name = String.valueOf(name) + sourceAttribute;
                } else {
                    name = sourceAttribute;
                }
            }
            ICompilationUnit unit = null;
            try {
                unit = (ICompilationUnit)project.findElement((IPath)new Path(name));
                if (unit != null) {
                    try {
                        return unit.getCorrespondingResource();
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
            catch (JavaModelException javaModelException) {}
            return null;
        }
    }

    class BuiltProjectVisitor
    implements IResourceDeltaVisitor {
        protected List fProjects = new ArrayList();

        BuiltProjectVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || (delta.getKind() & 4) == 0) {
                return false;
            }
            IResource resource = delta.getResource();
            if (resource != null && resource.getType() == 4) {
                this.fProjects.add(resource);
                return false;
            }
            return true;
        }

        public void reset() {
            this.fProjects = new ArrayList();
        }

        public List getBuiltProjects() {
            return this.fProjects;
        }
    }
}

