/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.internal.ui.SearchManager;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.SearchResultViewer;
import org.eclipse.search.internal.ui.text.ReplaceAction;
import org.eclipse.search.internal.ui.text.TextSearchOperation;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.dialogs.PropertyDialogAction;

class TextSearchActionGroup
extends ActionGroup {
    private ISelectionProvider fSelectionProvider;
    private IWorkbenchPage fPage;
    private PropertyDialogAction fOpenPropertiesDialog;

    public TextSearchActionGroup(IViewPart part) {
        Assert.isNotNull((Object)part);
        IWorkbenchPartSite site = part.getSite();
        this.fSelectionProvider = site.getSelectionProvider();
        this.fPage = site.getPage();
        this.fOpenPropertiesDialog = new PropertyDialogAction(site.getShell(), this.fSelectionProvider);
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.fOpenPropertiesDialog.selectionChanged((IStructuredSelection)selection);
        } else {
            this.fOpenPropertiesDialog.selectionChanged(selection);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        ReplaceAction replaceSelected;
        if (!this.isTextSearch()) {
            return;
        }
        ISearchResultView view = SearchUI.getSearchResultView();
        Object selection = null;
        selection = this.getContext().getSelection() instanceof IStructuredSelection ? (IStructuredSelection)this.getContext().getSelection() : StructuredSelection.EMPTY;
        this.addOpenWithMenu(menu, (IStructuredSelection)selection);
        ReplaceAction replaceAll = new ReplaceAction((IWorkbenchSite)view.getSite(), this.getSearchResultEntries());
        if (replaceAll.isEnabled()) {
            menu.appendToGroup("group.reorganize", (IAction)replaceAll);
        }
        if ((replaceSelected = new ReplaceAction((IWorkbenchSite)view.getSite(), (IStructuredSelection)selection)).isEnabled()) {
            menu.appendToGroup("group.reorganize", (IAction)replaceSelected);
        }
        if (this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection((IStructuredSelection)selection)) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    private List getSearchResultEntries() {
        SearchResultView view = (SearchResultView)SearchPlugin.getSearchResultView();
        SearchResultViewer viewer = view.getViewer();
        Table table = viewer.getTable();
        TableItem[] items = table.getItems();
        ArrayList<Object> elements = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            elements.add(items[i].getData());
            ++i;
        }
        return elements;
    }

    private boolean isTextSearch() {
        IRunnableWithProgress operation = SearchManager.getDefault().getCurrentSearch().getOperation();
        if (operation instanceof TextSearchOperation) {
            String pattern = ((TextSearchOperation)operation).getPattern();
            return pattern != null && pattern.length() > 0;
        }
        return false;
    }

    private void addOpenWithMenu(IMenuManager menu, IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (!(o instanceof ISearchResultViewEntry)) {
            return;
        }
        IResource resource = ((ISearchResultViewEntry)o).getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager(SearchMessages.getString("OpenWithMenu.label"));
        submenu.add((IContributionItem)new OpenWithMenu(this.fPage, (IAdaptable)((IFile)resource)));
        menu.appendToGroup("group.open", (IContributionItem)submenu);
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
    }
}

