/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.CopyToClipboardAction;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.basic.views.CollapseAllAction;
import org.eclipse.search2.internal.ui.basic.views.ExpandAllAction;
import org.eclipse.search2.internal.ui.basic.views.INavigate;
import org.eclipse.search2.internal.ui.basic.views.RemoveAllMatchesAction;
import org.eclipse.search2.internal.ui.basic.views.RemoveMatchAction;
import org.eclipse.search2.internal.ui.basic.views.RemoveSelectedMatchesAction;
import org.eclipse.search2.internal.ui.basic.views.SetLayoutAction;
import org.eclipse.search2.internal.ui.basic.views.ShowNextResultAction;
import org.eclipse.search2.internal.ui.basic.views.ShowPreviousResultAction;
import org.eclipse.search2.internal.ui.basic.views.TableViewerNavigator;
import org.eclipse.search2.internal.ui.basic.views.TreeViewerNavigator;
import org.eclipse.search2.internal.ui.text.AnnotationManagers;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractTextSearchViewPage
extends Page
implements ISearchResultPage {
    private transient boolean fIsUIUpdateScheduled = false;
    private static final String KEY_LAYOUT = "org.eclipse.search.resultpage.layout";
    protected static final Match[] EMPTY_MATCH_ARRAY = new Match[0];
    private StructuredViewer fViewer;
    private Composite fViewerContainer;
    private Control fBusyLabel;
    private PageBook fPagebook;
    private boolean fIsBusyShown;
    private ISearchResultViewPart fViewPart;
    private Set fBatchedUpdates;
    private ISearchResultListener fListener;
    private IQueryListener fQueryListener;
    private MenuManager fMenu;
    private ISearchResult fInput;
    private Action fCopyToClipboardAction;
    private Action fRemoveSelectedMatches;
    private Action fRemoveCurrentMatch;
    private Action fRemoveAllResultsAction;
    private Action fShowNextAction;
    private Action fShowPreviousAction;
    private SetLayoutAction fFlatAction;
    private SetLayoutAction fHierarchicalAction;
    private int fCurrentLayout;
    private int fCurrentMatchIndex = 0;
    private String fId;
    private int fSupportedLayouts;
    public static final int FLAG_LAYOUT_FLAT = 1;
    public static final int FLAG_LAYOUT_TREE = 2;
    private SelectionProviderAdapter fViewerAdapter;

    protected AbstractTextSearchViewPage(int supportedLayouts) {
        this.fSupportedLayouts = supportedLayouts;
        this.initLayout();
        this.fRemoveAllResultsAction = new RemoveAllMatchesAction(this);
        this.fRemoveSelectedMatches = new RemoveSelectedMatchesAction(this);
        this.fRemoveCurrentMatch = new RemoveMatchAction(this);
        this.fShowNextAction = new ShowNextResultAction(this);
        this.fShowPreviousAction = new ShowPreviousResultAction(this);
        this.createLayoutActions();
        this.fBatchedUpdates = new HashSet();
        this.fListener = new ISearchResultListener(){

            public void searchResultChanged(SearchResultEvent e) {
                AbstractTextSearchViewPage.this.handleSearchResultsChanged(e);
            }
        };
    }

    private void initLayout() {
        this.fCurrentLayout = this.supportsTreeLayout() ? 2 : 1;
    }

    protected AbstractTextSearchViewPage() {
        this(3);
    }

    private void createLayoutActions() {
        if (this.countBits(this.fSupportedLayouts) > 1) {
            this.fFlatAction = new SetLayoutAction(this, SearchMessages.getString("AbstractTextSearchViewPage.flat_layout.label"), SearchMessages.getString("AbstractTextSearchViewPage.flat_layout.tooltip"), 1);
            this.fHierarchicalAction = new SetLayoutAction(this, SearchMessages.getString("AbstractTextSearchViewPage.hierarchical_layout.label"), SearchMessages.getString("AbstractTextSearchViewPage.hierarchical_layout.tooltip"), 2);
            SearchPluginImages.setImageDescriptors((IAction)this.fFlatAction, "lcl16/", "org.eclipse.search.ui.flatLayout.gif");
            SearchPluginImages.setImageDescriptors((IAction)this.fHierarchicalAction, "lcl16/", "org.eclipse.search.ui.hierarchicalLayout.gif");
        }
    }

    private int countBits(int layoutFlags) {
        int bitCount = 0;
        int i = 0;
        while (i < 32) {
            if (layoutFlags % 2 == 1) {
                ++bitCount;
            }
            layoutFlags >>= 1;
            ++i;
        }
        return bitCount;
    }

    private boolean supportsTreeLayout() {
        return this.isLayoutSupported(2);
    }

    protected IDialogSettings getSettings() {
        IDialogSettings parent = SearchPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = parent.getSection(this.getID());
        if (settings == null) {
            settings = parent.addNewSection(this.getID());
        }
        return settings;
    }

    public void setID(String id) {
        this.fId = id;
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return "";
        }
        return result.getLabel();
    }

    protected void showMatch(Match match, int currentOffset, int currentLength) throws PartInitException {
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        this.showMatch(match, currentOffset, currentLength);
    }

    protected abstract void elementsChanged(Object[] var1);

    protected abstract void clear();

    protected abstract void configureTreeViewer(TreeViewer var1);

    protected abstract void configureTableViewer(TableViewer var1);

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.appendToGroup("additions", (IAction)this.fCopyToClipboardAction);
        mgr.appendToGroup("group.show", (IAction)this.fShowNextAction);
        mgr.appendToGroup("group.show", (IAction)this.fShowPreviousAction);
        if (this.getCurrentMatch() != null) {
            mgr.appendToGroup("group.removeMatches", (IAction)this.fRemoveCurrentMatch);
        }
        if (!this.getViewer().getSelection().isEmpty()) {
            mgr.appendToGroup("group.removeMatches", (IAction)this.fRemoveSelectedMatches);
        }
        mgr.appendToGroup("group.removeMatches", (IAction)this.fRemoveAllResultsAction);
    }

    public void createControl(Composite parent) {
        this.fQueryListener = this.createQueryListener();
        this.fMenu = new MenuManager("#PopUp");
        this.fMenu.setRemoveAllWhenShown(true);
        this.fMenu.setParent((IContributionManager)this.getSite().getActionBars().getMenuManager());
        this.fMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SearchView.createStandardGroups((IContributionManager)mgr);
                AbstractTextSearchViewPage.this.fillContextMenu(mgr);
                AbstractTextSearchViewPage.this.fViewPart.fillContextMenu(mgr);
            }
        });
        this.fPagebook = new PageBook(parent, 0);
        this.fPagebook.setLayoutData((Object)new GridData(1808));
        this.fBusyLabel = this.createBusyControl();
        this.fViewerContainer = new Composite((Composite)this.fPagebook, 0);
        this.fViewerContainer.setLayoutData((Object)new GridData(1808));
        this.fViewerContainer.setSize(100, 100);
        this.fViewerContainer.setLayout((Layout)new FillLayout());
        this.fViewerAdapter = new SelectionProviderAdapter();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewerAdapter);
        this.getSite().registerContextMenu(this.fViewPart.getViewSite().getId(), this.fMenu, (ISelectionProvider)this.fViewerAdapter);
        this.createViewer(this.fViewerContainer, this.fCurrentLayout);
        this.showBusyLabel(this.fIsBusyShown);
        NewSearchUI.addQueryListener(this.fQueryListener);
    }

    private Control createBusyControl() {
        Table busyLabel = new Table((Composite)this.fPagebook, 0);
        TableItem item = new TableItem(busyLabel, 0);
        item.setText(SearchMessages.getString("AbstractTextSearchViewPage.searching.label"));
        busyLabel.setLayoutData((Object)new GridData(768));
        return busyLabel;
    }

    private synchronized void scheduleUIUpdate() {
        if (!this.fIsUIUpdateScheduled) {
            this.fIsUIUpdateScheduled = true;
            new UpdateUIJob().schedule();
        }
    }

    private IQueryListener createQueryListener() {
        return new IQueryListener(){

            public void queryAdded(ISearchQuery query) {
            }

            public void queryRemoved(ISearchQuery query) {
            }

            public void queryStarting(ISearchQuery query) {
                Runnable runnable1 = new Runnable(this, query){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ ISearchQuery val$query;
                    {
                        this.this$1 = var1_1;
                        this.val$query = iSearchQuery;
                    }

                    public void run() {
                        AbstractTextSearchViewPage.access$8(3.access$0(this.this$1));
                        AbstractTextSearchResult result = 3.access$0(this.this$1).getInput();
                        if (result == null || !result.getQuery().equals(this.val$query)) {
                            return;
                        }
                        AbstractTextSearchViewPage.access$9(3.access$0(this.this$1));
                        AbstractTextSearchViewPage.access$10(3.access$0(this.this$1));
                    }
                };
                AbstractTextSearchViewPage.this.asyncExec(runnable1);
            }

            public void queryFinished(ISearchQuery query) {
                Runnable runnable2 = new Runnable(this, query){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ ISearchQuery val$query;
                    {
                        this.this$1 = var1_1;
                        this.val$query = iSearchQuery;
                    }

                    public void run() {
                        AbstractTextSearchViewPage.access$8(3.access$0(this.this$1));
                        AbstractTextSearchResult result = 3.access$0(this.this$1).getInput();
                        if (result == null || !result.getQuery().equals(this.val$query)) {
                            return;
                        }
                        if (AbstractTextSearchViewPage.access$6(3.access$0(this.this$1)).getSelection().isEmpty()) {
                            AbstractTextSearchViewPage.access$12(3.access$0(this.this$1), true);
                        }
                    }
                };
                AbstractTextSearchViewPage.this.asyncExec(runnable2);
            }

            static /* synthetic */ AbstractTextSearchViewPage access$0(3 var0) {
                return var0.AbstractTextSearchViewPage.this;
            }
        };
    }

    private void updateBusyLabel() {
        boolean shouldShowBusy;
        AbstractTextSearchResult result = this.getInput();
        boolean bl = shouldShowBusy = result != null && NewSearchUI.isQueryRunning(result.getQuery()) && result.getMatchCount() == 0;
        if (shouldShowBusy == this.fIsBusyShown) {
            return;
        }
        this.fIsBusyShown = shouldShowBusy;
        this.showBusyLabel(this.fIsBusyShown);
    }

    private void showBusyLabel(boolean shouldShowBusy) {
        if (shouldShowBusy) {
            this.fPagebook.showPage(this.fBusyLabel);
        } else {
            this.fPagebook.showPage((Control)this.fViewerContainer);
        }
    }

    public boolean isLayoutSupported(int layout) {
        return (layout & this.fSupportedLayouts) == layout;
    }

    public void setLayout(int layout) {
        Assert.isTrue((this.countBits(layout) == 1 ? 1 : 0) != 0);
        Assert.isTrue((boolean)this.isLayoutSupported(layout));
        if (this.countBits(this.fSupportedLayouts) < 2) {
            return;
        }
        if (this.fCurrentLayout == layout) {
            return;
        }
        this.fCurrentLayout = layout;
        ISelection selection = this.fViewer.getSelection();
        ISearchResult result = this.disconnectViewer();
        this.disposeViewer();
        this.createViewer(this.fViewerContainer, layout);
        this.fViewerContainer.layout(true);
        this.connectViewer(result);
        this.fViewer.setSelection(selection, true);
        this.getSettings().put(KEY_LAYOUT, layout);
        this.getViewPart().updateLabel();
    }

    private void disposeViewer() {
        this.fViewer.removeSelectionChangedListener((ISelectionChangedListener)this.fViewerAdapter);
        this.fViewer.getControl().dispose();
        this.fViewer = null;
    }

    private void updateLayoutActions() {
        if (this.fFlatAction != null) {
            this.fFlatAction.setChecked(this.fCurrentLayout == this.fFlatAction.getLayout());
        }
        if (this.fHierarchicalAction != null) {
            this.fHierarchicalAction.setChecked(this.fCurrentLayout == this.fHierarchicalAction.getLayout());
        }
    }

    public int getLayout() {
        return this.fCurrentLayout;
    }

    private void createViewer(Composite parent, int layout) {
        TableViewer viewer;
        if ((layout & 1) != 0) {
            viewer = this.createTableViewer(parent);
            this.fViewer = viewer;
            this.configureTableViewer(viewer);
        } else if ((layout & 2) != 0) {
            viewer = this.createTreeViewer(parent);
            this.fViewer = viewer;
            this.configureTreeViewer((TreeViewer)viewer);
        }
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        SearchView.createStandardGroups((IContributionManager)tbm);
        this.fillToolbar(tbm);
        tbm.update(false);
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                AbstractTextSearchViewPage.this.handleOpen(event);
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractTextSearchViewPage.this.fCurrentMatchIndex = -1;
                AbstractTextSearchViewPage.this.fRemoveSelectedMatches.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.fViewerAdapter);
        Menu menu = this.fMenu.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.updateLayoutActions();
        this.getViewPart().updateLabel();
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 770);
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new TableViewer(parent, 66306){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
                this.getTable().setRedraw(false);
                try {
                    super.handleLabelProviderChanged(event);
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    this.getTable().setRedraw(true);
                    throw throwable;
                }
                {
                    Object var2_4 = null;
                }
                this.getTable().setRedraw(true);
            }
        };
    }

    public void setFocus() {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public Control getControl() {
        return this.fPagebook;
    }

    public void setInput(ISearchResult search, Object viewState) {
        ISearchResult oldSearch = this.disconnectViewer();
        if (oldSearch != null) {
            oldSearch.removeListener(this.fListener);
        }
        AnnotationManagers.searchResultActivated(this.getSite().getWorkbenchWindow(), (AbstractTextSearchResult)search);
        this.fInput = search;
        if (search != null) {
            search.addListener(this.fListener);
            this.connectViewer(search);
            if (viewState instanceof ISelection) {
                this.fViewer.setSelection((ISelection)viewState, true);
            } else {
                this.navigateNext(true);
            }
        }
        this.updateBusyLabel();
        this.turnOffDecoration();
        this.scheduleUIUpdate();
    }

    public Object getUIState() {
        return this.fViewer.getSelection();
    }

    private void connectViewer(ISearchResult search) {
        this.fCopyToClipboardAction = new CopyToClipboardAction(this.fViewer);
        this.fViewer.setInput((Object)search);
    }

    private ISearchResult disconnectViewer() {
        ISearchResult result = (ISearchResult)this.fViewer.getInput();
        this.fViewer.setInput(null);
        return result;
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    private void showMatch(final Match match, final boolean activateEditor) {
        ISafeRunnable runnable = new ISafeRunnable(){

            public void handleException(Throwable exception) {
                if (exception instanceof PartInitException) {
                    PartInitException pie = (PartInitException)exception;
                    ErrorDialog.openError((Shell)AbstractTextSearchViewPage.this.getSite().getShell(), (String)SearchMessages.getString("DefaultSearchViewPage.show_match"), (String)SearchMessages.getString("DefaultSearchViewPage.error.no_editor"), (IStatus)pie.getStatus());
                }
            }

            public void run() throws Exception {
                Position currentPosition = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
                if (currentPosition != null) {
                    AbstractTextSearchViewPage.this.showMatch(match, currentPosition.getOffset(), currentPosition.getLength(), activateEditor);
                } else {
                    AbstractTextSearchViewPage.this.showMatch(match, match.getOffset(), match.getLength(), activateEditor);
                }
            }
        };
        Platform.run((ISafeRunnable)runnable);
    }

    public AbstractTextSearchResult getInput() {
        return (AbstractTextSearchResult)this.fInput;
    }

    public void gotoNextMatch() {
        this.gotoNextMatch(false);
    }

    private void gotoNextMatch(boolean activateEditor) {
        ++this.fCurrentMatchIndex;
        Match nextMatch = this.getCurrentMatch();
        if (nextMatch == null) {
            this.navigateNext(true);
            this.fCurrentMatchIndex = 0;
        }
        this.showCurrentMatch(activateEditor);
    }

    public void gotoPreviousMatch() {
        this.gotoPreviousMatch(false);
    }

    private void gotoPreviousMatch(boolean activateEditor) {
        --this.fCurrentMatchIndex;
        Match nextMatch = this.getCurrentMatch();
        if (nextMatch == null) {
            this.navigateNext(false);
            this.fCurrentMatchIndex = this.getInput().getMatchCount(this.getFirstSelectedElement()) - 1;
        }
        this.showCurrentMatch(activateEditor);
    }

    private void navigateNext(boolean forward) {
        INavigate navigator = null;
        navigator = this.fViewer instanceof TableViewer ? new TableViewerNavigator((TableViewer)this.fViewer) : new TreeViewerNavigator(this, (TreeViewer)this.fViewer);
        navigator.navigateNext(forward);
    }

    private boolean showCurrentMatch(boolean activateEditor) {
        Match currentMatch = this.getCurrentMatch();
        if (currentMatch != null) {
            this.showMatch(currentMatch, activateEditor);
            return true;
        }
        return false;
    }

    public Match getCurrentMatch() {
        Object element = this.getFirstSelectedElement();
        if (element != null) {
            Match[] matches = this.getDisplayedMatches(element);
            if (this.fCurrentMatchIndex >= 0 && this.fCurrentMatchIndex < matches.length) {
                return matches[this.fCurrentMatchIndex];
            }
        }
        return null;
    }

    public Match[] getDisplayedMatches(Object element) {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return EMPTY_MATCH_ARRAY;
        }
        return result.getMatches(element);
    }

    public int getDisplayedMatchCount(Object element) {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return 0;
        }
        return result.getMatchCount(element);
    }

    private Object getFirstSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() > 0) {
            return selection.getFirstElement();
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        NewSearchUI.removeQueryListener(this.fQueryListener);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.addLayoutActions(pageSite.getActionBars().getMenuManager());
        this.initActionDefinitionIDs(pageSite.getWorkbenchWindow());
        pageSite.getActionBars().getMenuManager().updateAll(true);
        pageSite.getActionBars().updateActionBars();
    }

    private void initActionDefinitionIDs(IWorkbenchWindow window) {
        this.fRemoveSelectedMatches.setActionDefinitionId(this.getActionDefinitionId(window, ActionFactory.DELETE));
        this.fShowNextAction.setActionDefinitionId(this.getActionDefinitionId(window, ActionFactory.NEXT));
        this.fShowPreviousAction.setActionDefinitionId(this.getActionDefinitionId(window, ActionFactory.PREVIOUS));
    }

    private String getActionDefinitionId(IWorkbenchWindow window, ActionFactory factory) {
        ActionFactory.IWorkbenchAction action = factory.create(window);
        String id = action.getActionDefinitionId();
        action.dispose();
        return id;
    }

    protected void fillToolbar(IToolBarManager tbm) {
        tbm.appendToGroup("group.show", (IAction)this.fShowNextAction);
        tbm.appendToGroup("group.show", (IAction)this.fShowPreviousAction);
        tbm.appendToGroup("group.removeMatches", (IAction)this.fRemoveSelectedMatches);
        tbm.appendToGroup("group.removeMatches", (IAction)this.fRemoveAllResultsAction);
        IActionBars actionBars = this.getSite().getActionBars();
        this.getSite().getWorkbenchWindow();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fShowNextAction);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fShowPreviousAction);
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fRemoveSelectedMatches);
        }
        if (this.getLayout() == 2) {
            this.addTreeActions(tbm);
        }
    }

    private void addTreeActions(IToolBarManager tbm) {
        tbm.appendToGroup("group.viewerSetup", (IAction)new ExpandAllAction((TreeViewer)this.getViewer()));
        tbm.appendToGroup("group.viewerSetup", (IAction)new CollapseAllAction((TreeViewer)this.getViewer()));
    }

    private void addLayoutActions(IMenuManager menuManager) {
        if (this.fFlatAction != null) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)this.fFlatAction);
        }
        if (this.fHierarchicalAction != null) {
            menuManager.appendToGroup("group.viewerSetup", (IAction)this.fHierarchicalAction);
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    protected ISearchResultViewPart getViewPart() {
        return this.fViewPart;
    }

    private synchronized void handleSearchResultsChanged(SearchResultEvent e) {
        if (e instanceof MatchEvent) {
            MatchEvent me = (MatchEvent)e;
            this.postUpdate(me.getMatches());
        } else if (e instanceof RemoveAllEvent) {
            this.postClear();
        }
    }

    private synchronized void postUpdate(Match[] matches) {
        int i = 0;
        while (i < matches.length) {
            this.fBatchedUpdates.add(matches[i].getElement());
            ++i;
        }
        this.scheduleUIUpdate();
    }

    private synchronized void runBatchedUpdates() {
        this.elementsChanged(this.fBatchedUpdates.toArray());
        this.fBatchedUpdates.clear();
        this.updateBusyLabel();
    }

    private void postClear() {
        this.asyncExec(new Runnable(){

            public void run() {
                AbstractTextSearchViewPage.this.runClear();
            }
        });
    }

    private synchronized boolean hasMoreUpdates() {
        return this.fBatchedUpdates.size() > 0;
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning(result.getQuery());
        }
        return false;
    }

    private void runClear() {
        AbstractTextSearchViewPage abstractTextSearchViewPage = this;
        synchronized (abstractTextSearchViewPage) {
            this.fBatchedUpdates.clear();
            this.updateBusyLabel();
        }
        this.getViewPart().updateLabel();
        this.clear();
    }

    private void asyncExec(final Runnable runnable) {
        final Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay == null || !currentDisplay.equals(control.getDisplay())) {
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (control != null && !control.isDisposed()) {
                            runnable.run();
                        }
                    }
                });
            } else {
                runnable.run();
            }
        }
    }

    public void restoreState(IMemento memento) {
        if (this.countBits(this.fSupportedLayouts) > 1) {
            Integer layout;
            try {
                this.fCurrentLayout = this.getSettings().getInt(KEY_LAYOUT);
                if (this.fCurrentLayout == 0) {
                    this.initLayout();
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (memento != null && (layout = memento.getInteger(KEY_LAYOUT)) != null) {
                this.fCurrentLayout = layout;
                if (this.fCurrentLayout == 0) {
                    this.initLayout();
                }
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.countBits(this.fSupportedLayouts) > 1) {
            memento.putInteger(KEY_LAYOUT, this.fCurrentLayout);
        }
    }

    public void internalRemoveSelected() {
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return;
        }
        StructuredViewer viewer = this.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        HashSet set = new HashSet();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider cp = (ITreeContentProvider)viewer.getContentProvider();
            this.collectAllMatchesBelow(result, set, cp, selection.toArray());
        } else {
            this.collectAllMatches(set, selection.toArray());
        }
        Match[] matches = new Match[set.size()];
        set.toArray(matches);
        result.removeMatches(matches);
    }

    private void collectAllMatches(HashSet set, Object[] elements) {
        int j = 0;
        while (j < elements.length) {
            Match[] matches = this.getDisplayedMatches(elements[j]);
            int i = 0;
            while (i < matches.length) {
                set.add(matches[i]);
                ++i;
            }
            ++j;
        }
    }

    private void collectAllMatchesBelow(AbstractTextSearchResult result, Set set, ITreeContentProvider cp, Object[] elements) {
        int j = 0;
        while (j < elements.length) {
            Match[] matches = this.getDisplayedMatches(elements[j]);
            int i = 0;
            while (i < matches.length) {
                set.add(matches[i]);
                ++i;
            }
            Object[] children = cp.getChildren(elements[j]);
            this.collectAllMatchesBelow(result, set, cp, children);
            ++j;
        }
    }

    private void turnOffDecoration() {
        IBaseLabelProvider lp = this.fViewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(null);
        }
    }

    private void turnOnDecoration() {
        IBaseLabelProvider lp = this.fViewer.getLabelProvider();
        if (lp instanceof DecoratingLabelProvider) {
            ((DecoratingLabelProvider)lp).setLabelDecorator(PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        }
    }

    protected void handleOpen(OpenEvent event) {
        Viewer viewer = event.getViewer();
        boolean hasCurrentMatch = this.showCurrentMatch(OpenStrategy.activateOnOpen());
        ISelection sel = event.getSelection();
        if (viewer instanceof TreeViewer && sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            TreeViewer tv = (TreeViewer)this.getViewer();
            Object element = selection.getFirstElement();
            if (element != null) {
                if (!hasCurrentMatch && this.getDisplayedMatchCount(element) > 0) {
                    this.gotoNextMatch(OpenStrategy.activateOnOpen());
                } else {
                    tv.setExpandedState(element, !tv.getExpandedState(element));
                }
            }
            return;
        }
        if (!hasCurrentMatch) {
            this.gotoNextMatch(OpenStrategy.activateOnOpen());
        }
    }

    static /* synthetic */ void access$8(AbstractTextSearchViewPage abstractTextSearchViewPage) {
        abstractTextSearchViewPage.updateBusyLabel();
    }

    static /* synthetic */ void access$9(AbstractTextSearchViewPage abstractTextSearchViewPage) {
        abstractTextSearchViewPage.turnOffDecoration();
    }

    static /* synthetic */ void access$10(AbstractTextSearchViewPage abstractTextSearchViewPage) {
        abstractTextSearchViewPage.scheduleUIUpdate();
    }

    static /* synthetic */ void access$12(AbstractTextSearchViewPage abstractTextSearchViewPage, boolean bl) {
        abstractTextSearchViewPage.navigateNext(bl);
    }

    private class UpdateUIJob
    extends UIJob {
        public UpdateUIJob() {
            super(SearchMessages.getString("AbstractTextSearchViewPage.update_job.name"));
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Control control = AbstractTextSearchViewPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return Status.OK_STATUS;
            }
            AbstractTextSearchViewPage.this.runBatchedUpdates();
            if (AbstractTextSearchViewPage.this.hasMoreUpdates() || AbstractTextSearchViewPage.this.isQueryRunning()) {
                this.schedule(500L);
            } else {
                AbstractTextSearchViewPage.this.fIsUIUpdateScheduled = false;
                AbstractTextSearchViewPage.this.turnOnDecoration();
            }
            AbstractTextSearchViewPage.this.fViewPart.updateLabel();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == AbstractTextSearchViewPage.this;
        }
    }

    private class SelectionProviderAdapter
    implements ISelectionProvider,
    ISelectionChangedListener {
        private ArrayList fListeners = new ArrayList(5);

        SelectionProviderAdapter() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add(listener);
        }

        public ISelection getSelection() {
            return AbstractTextSearchViewPage.this.fViewer.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            AbstractTextSearchViewPage.this.fViewer.setSelection(selection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionChangedEvent wrappedEvent = new SelectionChangedEvent((ISelectionProvider)this, event.getSelection());
            Iterator listeners = this.fListeners.iterator();
            while (listeners.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners.next();
                listener.selectionChanged(wrappedEvent);
            }
        }
    }
}

