/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class TeamCapabilityHelper {
    private Map providerIdToPluginId = new HashMap();
    private static TeamCapabilityHelper singleton;
    private static final QualifiedName PROVIDER_PROP_KEY;

    static {
        PROVIDER_PROP_KEY = new QualifiedName("org.eclipse.team.core", "repository");
    }

    public static TeamCapabilityHelper getInstance() {
        if (singleton == null) {
            singleton = new TeamCapabilityHelper();
        }
        return singleton;
    }

    private TeamCapabilityHelper() {
        this.loadRepositoryProviderIds();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        int i = 0;
        while (i < projects.length) {
            try {
                this.processProject(projects[i], workbenchActivitySupport);
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    public void loadRepositoryProviderIds() {
        this.providerIdToPluginId.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.team.core.repository");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String id;
                    IConfigurationElement element = elements[j];
                    final String pluginId = extension.getDeclaringPluginDescriptor().getUniqueIdentifier();
                    if (element.getName().equals("repository") && (id = element.getAttribute("id")) != null) {
                        this.providerIdToPluginId.put(id, new IPluginContribution(){

                            public String getLocalId() {
                                return id;
                            }

                            public String getPluginId() {
                                return pluginId;
                            }
                        });
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void processProject(IProject project, IWorkbenchActivitySupport workbenchActivitySupport) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        String id = this.getProviderIdFor(project);
        if (id == null) {
            return;
        }
        HashSet activities = new HashSet(activityManager.getEnabledActivityIds());
        boolean changed = false;
        IPluginContribution contribution = (IPluginContribution)this.providerIdToPluginId.get(id);
        if (contribution == null) {
            return;
        }
        IIdentifier identifier = activityManager.getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution));
        if (activities.addAll(identifier.getActivityIds())) {
            changed = true;
        }
        if (changed) {
            workbenchActivitySupport.setEnabledActivityIds(activities);
        }
    }

    public String getProviderIdFor(IProject project) throws CoreException {
        String id = null;
        if (project.isAccessible()) {
            RepositoryProvider provider = (RepositoryProvider)project.getSessionProperty(PROVIDER_PROP_KEY);
            if (provider != null) {
                id = provider.getID();
            }
            id = project.getPersistentProperty(PROVIDER_PROP_KEY);
        }
        return id;
    }
}

