/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class TeamAction
extends ActionDelegate
implements IObjectActionDelegate,
IViewActionDelegate {
    protected IStructuredSelection selection;
    protected Shell shell;
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;
    private IWorkbenchPart targetPart;
    static /* synthetic */ Class class$0;

    public static Object[] getSelectedAdaptables(ISelection selection, Class c) {
        ArrayList<Object> result = null;
        if (!selection.isEmpty()) {
            result = new ArrayList<Object>();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = TeamAction.getAdapter(elements.next(), c);
                if (!c.isInstance(adapter)) continue;
                result.add(adapter);
            }
        }
        if (result != null && !result.isEmpty()) {
            return result.toArray((Object[])Array.newInstance(c, result.size()));
        }
        return (Object[])Array.newInstance(c, 0);
    }

    public static Object getAdapter(Object adaptable, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    protected IProject[] getSelectedProjects() {
        IResource[] selectedResources = this.getSelectedResources();
        if (selectedResources.length == 0) {
            return new IProject[0];
        }
        ArrayList<IResource> projects = new ArrayList<IResource>();
        int i = 0;
        while (i < selectedResources.length) {
            IResource resource = selectedResources[i];
            if (resource.getType() == 4) {
                projects.add(resource);
            }
            ++i;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    protected Object[] getSelectedResources(Class c) {
        return TeamAction.getSelectedAdaptables((ISelection)this.selection, c);
    }

    protected IResource[] getSelectedResources() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IResource[])this.getSelectedResources(clazz);
    }

    protected Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    protected final void run(final IRunnableWithProgress runnable, String problemMessage, int progressKind) {
        final Exception[] exceptions = new Exception[1];
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException interruptedException) {
                            exceptions[0] = null;
                        }
                    }
                });
                break;
            }
            default: {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
                    break;
                }
                catch (InvocationTargetException e) {
                    exceptions[0] = e;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    exceptions[0] = null;
                }
            }
        }
        if (exceptions[0] != null) {
            this.handle(exceptions[0], null, problemMessage);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            if (action != null) {
                this.setActionEnablement(action);
            }
        }
    }

    protected void setActionEnablement(IAction action) {
        try {
            action.setEnabled(this.isEnabled());
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() == 274) {
                action.setEnabled(true);
            }
            action.setEnabled(false);
            TeamPlugin.log((CoreException)((Object)e));
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null) {
            this.shell = targetPart.getSite().getShell();
            this.targetPart = targetPart;
        }
    }

    protected void handle(Exception exception, String title, String message) {
        Utils.handleError(this.getShell(), exception, title, message);
    }

    protected abstract boolean isEnabled() throws TeamException;

    protected Hashtable getProviderMapping() {
        return this.getProviderMapping(this.getSelectedResources());
    }

    protected Hashtable getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, ArrayList<IResource>> result = new Hashtable<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    protected IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    protected IWorkbenchPage getTargetPage() {
        if (this.getTargetPart() == null) {
            return TeamUIPlugin.getActivePage();
        }
        return this.getTargetPart().getSite().getPage();
    }

    protected IViewPart showView(String viewId) {
        try {
            return this.getTargetPage().showView(viewId);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void init(IViewPart view) {
        this.targetPart = view;
    }
}

