/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.ISynchronizeModelProviderDescriptor;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElementSorter;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.UnchangedResourceModelElement;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class HierarchicalModelProvider
extends SynchronizeModelProvider {
    private static final HierarchicalModelProviderDescriptor hierarchicalDescriptor = new HierarchicalModelProviderDescriptor();

    public HierarchicalModelProvider(ISynchronizePageConfiguration configuration, SyncInfoTree set) {
        super(configuration, (SyncInfoSet)set);
    }

    public ISynchronizeModelProviderDescriptor getDescriptor() {
        return hierarchicalDescriptor;
    }

    public ViewerSorter getViewerSorter() {
        return new SynchronizeModelElementSorter();
    }

    protected SyncInfoTree getSyncInfoTree() {
        return (SyncInfoTree)this.getSyncInfoSet();
    }

    protected IDiffElement[] createModelObjects(ISynchronizeModelElement container) {
        Object resource = null;
        resource = container == this.getModelRoot() ? ResourcesPlugin.getWorkspace().getRoot() : container.getResource();
        if (resource != null) {
            SyncInfoTree infoTree = this.getSyncInfoTree();
            IResource[] children = infoTree.members((IResource)resource);
            ISynchronizeModelElement[] nodes = new ISynchronizeModelElement[children.length];
            int i = 0;
            while (i < children.length) {
                nodes[i] = this.createModelObject(container, children[i]);
                ++i;
            }
            return nodes;
        }
        return new IDiffElement[0];
    }

    protected ISynchronizeModelElement createModelObject(ISynchronizeModelElement parent, IResource resource) {
        SyncInfo info = this.getSyncInfoTree().getSyncInfo(resource);
        SynchronizeModelElement newNode = info != null ? new SyncInfoModelElement(parent, info) : new UnchangedResourceModelElement(parent, resource);
        this.addToViewer(newNode);
        return newNode;
    }

    protected Object[] getModelObjects(IResource[] resources) {
        Object[] result = new Object[resources.length];
        int i = 0;
        while (i < resources.length) {
            result[i] = this.getModelObject(resources[i]);
            ++i;
        }
        return result;
    }

    protected void handleChange(ISynchronizeModelElement diffNode, SyncInfo info) {
        IResource local = info.getLocal();
        if (diffNode instanceof SyncInfoModelElement) {
            ((SyncInfoModelElement)diffNode).update(info);
            this.propogateConflictState(diffNode, false);
        } else {
            this.removeFromViewer(local);
            this.addResources(new IResource[]{local});
        }
    }

    protected void addResources(IResource[] added) {
        int i = 0;
        while (i < added.length) {
            ISynchronizeModelElement parent;
            IResource resource = added[i];
            ISynchronizeModelElement node = this.getModelObject(resource);
            if (node != null) {
                this.removeFromViewer(resource);
            }
            if ((parent = this.getModelObject((IResource)resource.getParent())) != null) {
                node = this.createModelObject(parent, resource);
                this.buildModelObjects(node);
            }
            ++i;
        }
    }

    protected IDiffElement[] buildModelObjects(ISynchronizeModelElement node) {
        IDiffElement[] children = this.createModelObjects(node);
        int i = 0;
        while (i < children.length) {
            IDiffElement element = children[i];
            if (element instanceof ISynchronizeModelElement) {
                this.buildModelObjects((ISynchronizeModelElement)element);
            }
            ++i;
        }
        return children;
    }

    protected void doAdd(ISynchronizeModelElement parent, ISynchronizeModelElement element) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getViewer();
        viewer.add((Object)parent, (Object)element);
    }

    protected void doRemove(ISynchronizeModelElement element) {
        AbstractTreeViewer viewer = (AbstractTreeViewer)this.getViewer();
        viewer.remove((Object)element);
    }

    protected void handleResourceAdditions(ISyncInfoTreeChangeEvent event) {
        IResource[] added = event.getAddedSubtreeRoots();
        this.addResources(added);
    }

    protected void handleResourceChanges(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos = event.getChangedResources();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            IResource local = info.getLocal();
            ISynchronizeModelElement diffNode = this.getModelObject(local);
            if (diffNode != null) {
                this.handleChange(diffNode, info);
            }
            ++i;
        }
    }

    protected void handleResourceRemovals(ISyncInfoTreeChangeEvent event) {
        IResource[] removedRoots = event.getRemovedSubtreeRoots();
        int i = 0;
        while (i < removedRoots.length) {
            this.removeFromViewer(removedRoots[i]);
            ++i;
        }
        IResource[] removedResources = event.getRemovedResources();
        int i2 = 0;
        while (i2 < removedResources.length) {
            ISynchronizeModelElement node;
            IResource resource = removedResources[i2];
            if (resource.getType() != 1 && (node = this.getModelObject(resource)) != null) {
                this.removeFromViewer(resource);
                this.addResources(new IResource[]{resource});
            }
            ++i2;
        }
    }

    public static class HierarchicalModelProviderDescriptor
    implements ISynchronizeModelProviderDescriptor {
        public static final String ID = "org.eclipse.team.ui.modelprovider_hierarchical";

        public String getId() {
            return ID;
        }

        public String getName() {
            return Policy.bind("HierarchicalModelProvider.0");
        }

        public ImageDescriptor getImageDescriptor() {
            return TeamImages.getImageDescriptor("elcl16/hierarchicalLayout.gif");
        }
    }
}

