/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.RemoteResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SynchronizeModelElement;

public class SyncInfoModelElement
extends SynchronizeModelElement {
    private ITypedElement ancestor;
    private SyncInfo info;
    static /* synthetic */ Class class$0;

    public SyncInfoModelElement(IDiffContainer parent, SyncInfo info) {
        super(parent);
        Assert.isNotNull((Object)info);
        this.info = info;
        this.setKind(info.getKind());
        this.setLeft(SyncInfoModelElement.createLocalTypeElement(info));
        this.setRight(SyncInfoModelElement.createRemoteTypeElement(info));
        this.setAncestor(SyncInfoModelElement.createBaseTypeElement(info));
        this.fireChange();
    }

    public void update(SyncInfo info) {
        this.info = info;
        this.setKind(info.getKind());
        RemoteResourceTypedElement rightEl = (RemoteResourceTypedElement)this.getRight();
        IResourceVariant remote = info.getRemote();
        if (rightEl == null && remote != null) {
            this.setRight(SyncInfoModelElement.createRemoteTypeElement(info));
        } else if (rightEl != null) {
            if (remote == null) {
                this.setRight(null);
            } else {
                rightEl.update(remote);
            }
        }
        RemoteResourceTypedElement ancestorEl = (RemoteResourceTypedElement)this.getAncestor();
        IResourceVariant base = info.getBase();
        if (ancestorEl == null && base != null) {
            this.setAncestor(SyncInfoModelElement.createBaseTypeElement(info));
        } else if (ancestorEl != null) {
            if (base == null) {
                this.setAncestor(null);
            } else {
                ancestorEl.update(base);
            }
        }
        this.fireChange();
    }

    public int getKind() {
        SyncInfo info = this.getSyncInfo();
        if (info != null) {
            return info.getKind();
        }
        return 0;
    }

    public void setAncestor(ITypedElement ancestor) {
        this.ancestor = ancestor;
    }

    public ITypedElement getAncestor() {
        return this.ancestor;
    }

    public String getName() {
        IResource resource = this.getResource();
        if (resource != null) {
            return resource.getName();
        }
        return super.getName();
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.core.synchronize.SyncInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getSyncInfo();
        }
        return super.getAdapter(adapter);
    }

    public IResource getResource() {
        return this.info.getLocal();
    }

    public String toString() {
        return this.getResource().getFullPath().toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cacheContents(IProgressMonitor monitor) throws TeamException {
        ITypedElement base = this.getAncestor();
        ITypedElement remote = this.getRight();
        int work = Math.min((remote == null ? 0 : 50) + (base == null ? 0 : 50), 10);
        monitor.beginTask(null, work);
        try {
            if (base != null && base instanceof RemoteResourceTypedElement) {
                ((RemoteResourceTypedElement)base).cacheContents(Policy.subMonitorFor(monitor, 50));
            }
            if (remote != null && remote instanceof RemoteResourceTypedElement) {
                ((RemoteResourceTypedElement)remote).cacheContents(Policy.subMonitorFor(monitor, 50));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public SyncInfo getSyncInfo() {
        return this.info;
    }

    private static ITypedElement createTypeElement(final IResource resource, final int kind) {
        if (resource != null) {
            return new LocalResourceTypedElement(resource){

                public boolean isEditable() {
                    if (!resource.exists() && SyncInfo.getDirection((int)kind) == 4 && SyncInfo.getChange((int)kind) == 2) {
                        return false;
                    }
                    return super.isEditable();
                }
            };
        }
        return null;
    }

    protected static ITypedElement createTypeElement(IResourceVariant remoteResource) {
        return new RemoteResourceTypedElement(remoteResource);
    }

    protected static ITypedElement createRemoteTypeElement(SyncInfo info) {
        if (info != null && info.getRemote() != null) {
            return SyncInfoModelElement.createTypeElement(info.getRemote());
        }
        return null;
    }

    protected static ITypedElement createLocalTypeElement(SyncInfo info) {
        if (info != null && info.getLocal() != null) {
            return SyncInfoModelElement.createTypeElement(info.getLocal(), info.getKind());
        }
        return null;
    }

    protected static ITypedElement createBaseTypeElement(SyncInfo info) {
        if (info != null && info.getBase() != null) {
            return SyncInfoModelElement.createTypeElement(info.getBase());
        }
        return null;
    }
}

