/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.internal.ui.synchronize.SynchronizeViewWorkbenchPart;
import org.eclipse.team.internal.ui.synchronize.WorkbenchPartSynchronizePageSite;
import org.eclipse.team.internal.ui.synchronize.actions.PinParticipantAction;
import org.eclipse.team.internal.ui.synchronize.actions.RemoveSynchronizeParticipantAction;
import org.eclipse.team.internal.ui.synchronize.actions.SynchronizePageDropDownAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SynchronizeView
extends PageBookView
implements ISynchronizeView,
ISynchronizeParticipantListener,
IPropertyChangeListener {
    public static final int MAX_NAME_LENGTH = 100;
    private ISynchronizeParticipant activeParticipantRef = null;
    private Map fParticipantToPart = new HashMap();
    private Map fPartToParticipant = new HashMap();
    private SynchronizePageDropDownAction fPageDropDown;
    private PinParticipantAction fPinAction;
    private RemoveSynchronizeParticipantAction fRemoveCurrentAction;
    private RemoveSynchronizeParticipantAction fRemoveAllAction;
    private static final String KEY_LAST_ACTIVE_PARTICIPANT = "lastactiveparticipant";
    private static final String KEY_SETTINGS_SECTION = "SynchronizeViewSettings";
    static /* synthetic */ Class class$0;

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof ISynchronizeParticipant && event.getProperty().equals("org.eclipse.jface.text") && source.equals(this.getParticipant())) {
            this.updateTitle();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
    }

    public ISynchronizeParticipant getParticipant() {
        return this.activeParticipantRef;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        super.showPageRec(pageRec);
        this.activeParticipantRef = (ISynchronizeParticipant)this.fPartToParticipant.get(pageRec.part);
        this.updateActionEnablements();
        this.updateTitle();
    }

    protected void updateTitle() {
        ISynchronizeParticipant participant = this.getParticipant();
        if (participant == null) {
            this.setContentDescription("");
        } else {
            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fParticipantToPart.get(participant);
            this.setContentDescription(Utils.shortenText(100, part.getParticipant().getName()));
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        SynchronizeViewWorkbenchPart syncPart = (SynchronizeViewWorkbenchPart)part;
        ISynchronizeParticipant participant = syncPart.getParticipant();
        this.clearCrossReferenceCache(part, participant);
    }

    private void clearCrossReferenceCache(IWorkbenchPart part, ISynchronizeParticipant participant) {
        participant.removePropertyChangeListener(this);
        this.fPartToParticipant.remove(part);
        this.fParticipantToPart.remove(participant);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)dummyPart;
        ISynchronizeParticipant participant = part.getParticipant();
        participant.addPropertyChangeListener(this);
        ISynchronizePageConfiguration configuration = participant.createPageConfiguration();
        IPageBookViewPage page = participant.createPage(configuration);
        if (page != null) {
            this.initPage(page);
            this.initPage(configuration, page);
            page.createControl((Composite)this.getPageBook());
            PageBookView.PageRec rec = new PageBookView.PageRec(dummyPart, (IPage)page);
            return rec;
        }
        return null;
    }

    protected void initPage(ISynchronizePageConfiguration configuration, IPageBookViewPage page) {
        ((SynchronizePageConfiguration)configuration).setSite(new WorkbenchPartSynchronizePageSite((IWorkbenchPart)this, page.getSite(), this.getDialogSettings(configuration.getParticipant())));
        if (page instanceof ISynchronizePage) {
            try {
                ((ISynchronizePage)page).init(configuration.getSite());
            }
            catch (PartInitException e) {
                TeamUIPlugin.log(4, e.getMessage(), e);
            }
        }
        page.getSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fPageDropDown);
        page.getSite().getActionBars().updateActionBars();
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof SynchronizeViewWorkbenchPart;
    }

    public void dispose() {
        super.dispose();
        TeamUI.getSynchronizeManager().removeSynchronizeParticipantListener(this);
        if (this.activeParticipantRef != null) {
            IDialogSettings section = this.getDialogSettings();
            section.put(KEY_LAST_ACTIVE_PARTICIPANT, this.activeParticipantRef.getId());
        }
        this.fParticipantToPart = null;
        this.fPartToParticipant = null;
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    public void participantsAdded(ISynchronizeParticipant[] participants) {
        int i = 0;
        while (i < participants.length) {
            ISynchronizeParticipant participant = participants[i];
            if (this.isAvailable() && this.select(TeamUI.getSynchronizeManager().get(participant.getId(), participant.getSecondaryId()))) {
                SynchronizeViewWorkbenchPart part = new SynchronizeViewWorkbenchPart(participant, this.getSite());
                this.fParticipantToPart.put(participant, part);
                this.fPartToParticipant.put(part, participant);
            }
            ++i;
        }
    }

    public void participantsRemoved(final ISynchronizeParticipant[] participants) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < participants.length) {
                        ISynchronizeParticipant participant = participants[i];
                        if (SynchronizeView.this.isAvailable()) {
                            ISynchronizeParticipantReference[] available;
                            SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)SynchronizeView.this.fParticipantToPart.get(participant);
                            if (part != null) {
                                SynchronizeView.this.partClosed(part);
                                SynchronizeView.this.clearCrossReferenceCache(part, participant);
                            }
                            SynchronizeView.this.removeDialogSettings(participant);
                            if (SynchronizeView.this.getParticipant() == null && (available = TeamUI.getSynchronizeManager().getSynchronizeParticipants()).length > 0) {
                                ISynchronizeParticipant p;
                                try {
                                    p = available[available.length - 1].getParticipant();
                                }
                                catch (TeamException teamException) {
                                    return;
                                }
                                SynchronizeView.this.display(p);
                            }
                        }
                        ++i;
                    }
                }
            };
            this.asyncExec(r);
        }
    }

    public SynchronizeView() {
        this.updateTitle();
    }

    protected void createActions() {
        this.fPageDropDown = new SynchronizePageDropDownAction(this);
        this.fPinAction = new PinParticipantAction();
        this.fRemoveCurrentAction = new RemoveSynchronizeParticipantAction(this, false);
        this.fRemoveAllAction = new RemoveSynchronizeParticipantAction(this, true);
        this.updateActionEnablements();
    }

    private void updateActionEnablements() {
        if (this.fPinAction != null) {
            this.fPinAction.setParticipant(this.activeParticipantRef);
        }
        if (this.fRemoveAllAction != null) {
            this.fRemoveAllAction.setEnabled(this.getParticipant() != null);
        }
        if (this.fRemoveCurrentAction != null) {
            this.fRemoveCurrentAction.setEnabled(this.getParticipant() != null);
        }
    }

    protected void configureToolBar(IActionBars bars) {
        IToolBarManager mgr = bars.getToolBarManager();
        mgr.add((IAction)this.fPageDropDown);
        mgr.add((IAction)this.fPinAction);
        IMenuManager menu = bars.getMenuManager();
        menu.add((IAction)this.fRemoveCurrentAction);
        menu.add((IAction)this.fRemoveAllAction);
    }

    public void display(ISynchronizeParticipant participant) {
        SynchronizeViewWorkbenchPart part = (SynchronizeViewWorkbenchPart)this.fParticipantToPart.get(participant);
        if (part != null) {
            this.partActivated(part);
            this.fPageDropDown.update();
        }
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(r);
        }
    }

    public void createPartControl(Composite parent) {
        IWorkbenchSiteProgressService progress;
        super.createPartControl(parent);
        this.createActions();
        this.configureToolBar(this.getViewSite().getActionBars());
        this.updateForExistingParticipants();
        this.getViewSite().getActionBars().updateActionBars();
        this.updateTitle();
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((progress = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            progress.showBusyForFamily(ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION);
        }
    }

    private void updateForExistingParticipants() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        List<ISynchronizeParticipantReference> participants = Arrays.asList(this.getParticipants());
        boolean errorOccurred = false;
        int i = 0;
        while (i < participants.size()) {
            try {
                ISynchronizeParticipantReference ref = participants.get(i);
                this.participantsAdded(new ISynchronizeParticipant[]{ref.getParticipant()});
            }
            catch (TeamException teamException) {
                errorOccurred = true;
            }
            ++i;
        }
        if (errorOccurred) {
            participants = Arrays.asList(this.getParticipants());
        }
        try {
            if (participants.size() > 0) {
                ISynchronizeParticipantReference selectedParticipant;
                ISynchronizeParticipantReference participantToSelect = participants.get(0);
                IDialogSettings section = this.getDialogSettings();
                String selectedParticipantId = section.get(KEY_LAST_ACTIVE_PARTICIPANT);
                if (selectedParticipantId != null && (selectedParticipant = manager.get(selectedParticipantId, null)) != null) {
                    participantToSelect = selectedParticipant;
                }
                this.display(participantToSelect.getParticipant());
            }
            manager.addSynchronizeParticipantListener(this);
        }
        catch (TeamException e) {
            Utils.handle(e);
        }
    }

    private ISynchronizeParticipantReference[] getParticipants() {
        ISynchronizeManager manager = TeamUI.getSynchronizeManager();
        ArrayList<ISynchronizeParticipantReference> participants = new ArrayList<ISynchronizeParticipantReference>();
        ISynchronizeParticipantReference[] refs = manager.getSynchronizeParticipants();
        int i = 0;
        while (i < refs.length) {
            ISynchronizeParticipantReference ref = refs[i];
            if (this.select(ref)) {
                participants.add(ref);
            }
            ++i;
        }
        return participants.toArray(new ISynchronizeParticipantReference[participants.size()]);
    }

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    public IPage getPage(ISynchronizeParticipant participant) {
        IWorkbenchPart part = (IWorkbenchPart)this.fParticipantToPart.get(participant);
        if (part == null) {
            return null;
        }
        try {
            return this.getPageRec((IWorkbenchPart)part).page;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected boolean select(ISynchronizeParticipantReference ref) {
        return true;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = TeamUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings syncViewSettings = workbenchSettings.getSection(KEY_SETTINGS_SECTION);
        if (syncViewSettings == null) {
            syncViewSettings = workbenchSettings.addNewSection(KEY_SETTINGS_SECTION);
        }
        return syncViewSettings;
    }

    private String getSettingsKey(ISynchronizeParticipant participant) {
        String id = participant.getId();
        String secondaryId = participant.getSecondaryId();
        return secondaryId == null ? id : String.valueOf(id) + '.' + secondaryId;
    }

    private IDialogSettings getDialogSettings(ISynchronizeParticipant participant) {
        String key = this.getSettingsKey(participant);
        IDialogSettings viewsSettings = this.getDialogSettings();
        IDialogSettings settings = viewsSettings.getSection(key);
        if (settings == null) {
            settings = viewsSettings.addNewSection(key);
        }
        return settings;
    }

    private void removeDialogSettings(ISynchronizeParticipant participant) {
        String key = this.getSettingsKey(participant);
        IDialogSettings settings = this.getDialogSettings();
        if (settings.getSection(key) != null) {
            this.getDialogSettings().addSection((IDialogSettings)new DialogSettings(key));
        }
    }
}

