/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditorContributor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class FeatureSpecSection
extends PDESection {
    public static final String SECTION_TITLE = "FeatureEditor.SpecSection.title";
    public static final String SECTION_DESC = "FeatureEditor.SpecSection.desc";
    public static final String SECTION_ID = "FeatureEditor.SpecSection.id";
    public static final String SECTION_NAME = "FeatureEditor.SpecSection.name";
    public static final String SECTION_VERSION = "FeatureEditor.SpecSection.version";
    public static final String SECTION_PROVIDER = "FeatureEditor.SpecSection.provider";
    public static final String SECTION_PLUGIN = "FeatureEditor.SpecSection.plugin";
    public static final String SECTION_IMAGE = "FeatureEditor.SpecSection.image";
    public static final String SECTION_BROWSE = "FeatureEditor.SpecSection.browse";
    public static final String SECTION_PRIMARY = "FeatureEditor.SpecSection.primary";
    public static final String SECTION_EXCLUSIVE = "FeatureEditor.SpecSection.exclusive";
    public static final String SECTION_CREATE_JAR = "FeatureEditor.SpecSection.createJar";
    public static final String SECTION_SYNCHRONIZE = "FeatureEditor.SpecSection.synchronize";
    public static final String KEY_BAD_VERSION_TITLE = "FeatureEditor.SpecSection.badVersionTitle";
    public static final String KEY_BAD_VERSION_MESSAGE = "FeatureEditor.SpecSection.badVersionMessage";
    private FormEntry idText;
    private FormEntry titleText;
    private FormEntry versionText;
    private FormEntry providerText;
    private FormEntry pluginText;
    private FormEntry imageText;
    private Button primaryButton;
    private Button exclusiveButton;
    private Button createJarButton;
    private Button synchronizeButton;
    private boolean blockNotification;

    public FeatureSpecSection(FeatureFormPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        this.titleText.commit();
        this.providerText.commit();
        this.pluginText.commit();
        this.idText.commit();
        this.versionText.commit();
        this.imageText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        final IFeature feature = model.getFeature();
        this.idText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_ID), null, false);
        this.idText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setId(text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.titleText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_NAME), null, false);
        this.titleText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setLabel(text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                FeatureSpecSection.this.getPage().getManagedForm().getForm().setText(model.getResourceString(feature.getLabel()));
                ((FeatureEditor)FeatureSpecSection.this.getPage().getEditor()).updateTitle();
            }
        });
        this.versionText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_VERSION), null, false);
        this.versionText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                if (!FeatureSpecSection.this.verifySetVersion(feature, text.getValue())) {
                    FeatureSpecSection.this.warnBadVersionFormat(text.getValue());
                    text.setValue(feature.getVersion());
                }
            }
        });
        this.providerText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_PROVIDER), null, false);
        this.providerText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setProviderName(FeatureSpecSection.this.getNonNullValue(text.getValue()));
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.pluginText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_PLUGIN), null, false);
        this.pluginText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setPlugin(FeatureSpecSection.this.getNonNullValue(text.getValue()));
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.imageText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_IMAGE), PDEPlugin.getResourceString(SECTION_BROWSE), false);
        this.imageText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setImageName(FeatureSpecSection.this.getNonNullValue(text.getValue()));
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                FeatureSpecSection.this.handleBrowseImage();
            }
        });
        GridData gd = (GridData)this.idText.getText().getLayoutData();
        gd.widthHint = 150;
        Composite checkContainer = toolkit.createComposite(container);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        checkContainer.setLayoutData((Object)gd);
        GridLayout blayout = new GridLayout();
        checkContainer.setLayout((Layout)blayout);
        blayout.numColumns = 2;
        blayout.marginWidth = 0;
        blayout.marginHeight = 0;
        this.primaryButton = toolkit.createButton(checkContainer, PDEPlugin.getResourceString(SECTION_PRIMARY), 32);
        gd = new GridData(256);
        this.primaryButton.setLayoutData((Object)gd);
        this.primaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!FeatureSpecSection.this.blockNotification) {
                        feature.setPrimary(FeatureSpecSection.this.primaryButton.getSelection());
                    }
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        });
        this.exclusiveButton = toolkit.createButton(checkContainer, PDEPlugin.getResourceString(SECTION_EXCLUSIVE), 32);
        gd = new GridData(256);
        this.exclusiveButton.setLayoutData((Object)gd);
        this.exclusiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (!FeatureSpecSection.this.blockNotification) {
                        feature.setExclusive(FeatureSpecSection.this.exclusiveButton.getSelection());
                    }
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        });
        Composite buttonContainer = toolkit.createComposite(container);
        gd = new GridData(128);
        gd.horizontalSpan = 3;
        buttonContainer.setLayoutData((Object)gd);
        blayout = new GridLayout();
        buttonContainer.setLayout((Layout)blayout);
        blayout.makeColumnsEqualWidth = true;
        blayout.numColumns = 2;
        blayout.marginWidth = 0;
        this.createJarButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_CREATE_JAR), 8);
        this.createJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSpecSection.this.handleCreateJar();
            }
        });
        gd = new GridData(770);
        this.createJarButton.setLayoutData((Object)gd);
        this.synchronizeButton = toolkit.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_SYNCHRONIZE), 8);
        this.synchronizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSpecSection.this.handleSynchronize();
            }
        });
        gd = new GridData(770);
        this.synchronizeButton.setLayoutData((Object)gd);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private String getNonNullValue(String value) {
        return value.length() > 0 ? value : null;
    }

    private boolean verifySetVersion(IFeature feature, String value) {
        try {
            PluginVersionIdentifier pvi = new PluginVersionIdentifier(value);
            feature.setVersion(pvi.toString());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void warnBadVersionFormat(String text) {
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(KEY_BAD_VERSION_TITLE), (String)PDEPlugin.getResourceString(KEY_BAD_VERSION_MESSAGE));
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void handleCreateJar() {
        final FeatureEditorContributor contributor = (FeatureEditorContributor)this.getPage().getPDEEditor().getContributor();
        BusyIndicator.showWhile((Display)this.createJarButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                contributor.getBuildAction().run();
            }
        });
    }

    private void handleSynchronize() {
        final FeatureEditorContributor contributor = (FeatureEditorContributor)this.getPage().getPDEEditor().getContributor();
        BusyIndicator.showWhile((Display)this.synchronizeButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                contributor.getSynchronizeAction().run();
            }
        });
    }

    private void handleBrowseImage() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IResource resource = model.getUnderlyingResource();
        final IProject project = resource.getProject();
        BusyIndicator.showWhile((Display)this.primaryButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(FeatureSpecSection.this.primaryButton.getShell(), (IAdaptable)project, null);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result == null || result.length == 0) {
                    return;
                }
                IResource resource = (IResource)result[0];
                FeatureSpecSection.this.acceptImage(resource);
            }
        });
    }

    private void acceptImage(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        this.imageText.setValue(path.toString());
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.idText.getText().setEditable(false);
            this.titleText.getText().setEditable(false);
            this.versionText.getText().setEditable(false);
            this.providerText.getText().setEditable(false);
            this.pluginText.getText().setEditable(false);
            this.imageText.getText().setEditable(false);
            this.primaryButton.setEnabled(false);
            this.exclusiveButton.setEnabled(false);
            this.createJarButton.setEnabled(false);
            this.synchronizeButton.setEnabled(false);
            this.imageText.getButton().setEnabled(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        Object[] objs;
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && objs[0] instanceof IFeature) {
            this.markStale();
        }
    }

    public void setFocus() {
        if (this.idText != null) {
            this.idText.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    public void refresh() {
        this.blockNotification = true;
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.setIfDefined(this.idText, feature.getId());
        this.setIfDefined(this.titleText, feature.getLabel());
        this.getPage().getManagedForm().getForm().setText(model.getResourceString(feature.getLabel()));
        this.setIfDefined(this.versionText, feature.getVersion());
        this.setIfDefined(this.providerText, feature.getProviderName());
        this.setIfDefined(this.pluginText, feature.getPlugin());
        this.setIfDefined(this.imageText, feature.getImageName());
        this.primaryButton.setSelection(feature.isPrimary());
        this.exclusiveButton.setSelection(feature.isExclusive());
        super.refresh();
        this.blockNotification = false;
    }

    public void cancelEdit() {
        this.idText.cancelEdit();
        this.titleText.cancelEdit();
        this.versionText.cancelEdit();
        this.providerText.cancelEdit();
        this.pluginText.cancelEdit();
        this.imageText.cancelEdit();
        super.cancelEdit();
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

