/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.plugin.rows.BooleanAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ChoiceAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ClassAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ExtensionAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ResourceAttributeRow;
import org.eclipse.pde.internal.ui.editor.plugin.rows.TextAttributeRow;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ExtensionElementDetails
extends PDEDetails {
    private IPluginElement input;
    private ISchemaElement schemaElement;
    private ArrayList rows;
    private Section section;

    public ExtensionElementDetails(ISchemaElement schemaElement) {
        this.schemaElement = schemaElement;
        this.rows = new ArrayList();
    }

    public String getContextId() {
        return "plugin-context";
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    public void createContents(Composite parent) {
        int span;
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 5;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.section = toolkit.createSection(parent, 384);
        this.section.clientVerticalSpacing = 4;
        this.section.marginHeight = 5;
        this.section.marginWidth = 5;
        this.section.setText(PDEPlugin.getResourceString("ExtensionElementDetails.title"));
        this.section.setDescription(PDEPlugin.getResourceString("ExtensionElementDetails.desc"));
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        this.section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)this.section);
        GridLayout glayout = new GridLayout();
        boolean paintedBorder = toolkit.getBorderStyle() != 2048;
        glayout.marginHeight = 2;
        glayout.marginWidth = 2;
        glayout.numColumns = span = 2;
        if (paintedBorder) {
            glayout.verticalSpacing = 7;
        }
        client.setLayout((Layout)glayout);
        if (this.schemaElement != null) {
            ISchemaAttribute[] atts = this.schemaElement.getAttributes();
            int i = 0;
            while (i < atts.length) {
                if (atts[i].getKind() == 1 || atts[i].getKind() == 2) {
                    span = 3;
                    break;
                }
                ++i;
            }
            glayout.numColumns = span;
            i = 0;
            while (i < atts.length) {
                if (atts[i].getUse() == 1) {
                    this.rows.add(this.createAttributeRow(atts[i], client, toolkit, span));
                }
                ++i;
            }
            i = 0;
            while (i < atts.length) {
                if (atts[i].getUse() != 1) {
                    this.rows.add(this.createAttributeRow(atts[i], client, toolkit, span));
                }
                ++i;
            }
            this.createSpacer(toolkit, client, span);
        }
        toolkit.paintBordersFor(client);
        this.section.setClient((Control)client);
        this.markDetailsPart((Control)this.section);
    }

    private ExtensionAttributeRow createAttributeRow(ISchemaAttribute att, Composite parent, FormToolkit toolkit, int span) {
        ISchemaRestriction restriction;
        ISchemaSimpleType type;
        ExtensionAttributeRow row = att.getKind() == 1 ? new ClassAttributeRow((IContextPart)this, att) : (att.getKind() == 2 ? new ResourceAttributeRow((IContextPart)this, att) : ((type = att.getType()).getName().equals("boolean") ? new BooleanAttributeRow((IContextPart)this, att) : ((restriction = type.getRestriction()) != null ? new ChoiceAttributeRow((IContextPart)this, att) : new TextAttributeRow((IContextPart)this, att))));
        ((ExtensionAttributeRow)row).createContents(parent, toolkit, span);
        return row;
    }

    private ExtensionAttributeRow createAttributeRow(IPluginAttribute att, Composite parent, FormToolkit toolkit, int span) {
        TextAttributeRow row = new TextAttributeRow((IContextPart)this, att);
        ((ExtensionAttributeRow)row).createContents(parent, toolkit, span);
        return row;
    }

    public void selectionChanged(IFormPart masterPart, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (IPluginElement)ssel.getFirstElement() : null;
        this.update();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object obj;
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]).equals(this.input)) {
            this.refresh();
        }
    }

    private void update() {
        this.updateDescription();
        if (this.schemaElement == null) {
            this.updateRows();
        }
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = (ExtensionAttributeRow)this.rows.get(i);
            row.setInput(this.input);
            ++i;
        }
    }

    private void updateRows() {
        if (this.input == null) {
            return;
        }
        IPluginAttribute[] atts = this.input.getAttributes();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        boolean rowsAdded = false;
        int i = 0;
        while (i < atts.length) {
            if (!this.hasAttribute(atts[i].getName())) {
                this.rows.add(this.createAttributeRow(atts[i], (Composite)this.section.getClient(), toolkit, 2));
                rowsAdded = true;
            }
            ++i;
        }
        if (rowsAdded) {
            ((Composite)this.section.getClient()).layout(true);
            this.section.layout(true);
            this.section.getParent().layout(true);
            this.reflow();
        }
    }

    private void reflow() {
        Composite parent = this.section.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                ((SharedScrolledComposite)parent).reflow(true);
                return;
            }
            parent = parent.getParent();
        }
    }

    private boolean hasAttribute(String attName) {
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = (ExtensionAttributeRow)this.rows.get(i);
            if (row.getName().equals(attName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateDescription() {
        if (this.input != null) {
            String iname = this.input.getName();
            this.section.setDescription(PDEPlugin.getFormattedMessage("ExtensionElementDetails.setDesc", iname));
        } else {
            this.section.setDescription(PDEPlugin.getResourceString("ExtensionElementDetails.setSelectedDesc"));
        }
        this.section.layout();
    }

    public void commit(boolean onSave) {
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = (ExtensionAttributeRow)this.rows.get(i);
            row.commit();
            ++i;
        }
        super.commit(onSave);
    }

    public void setFocus() {
        if (this.rows.size() > 0) {
            ((ExtensionAttributeRow)this.rows.get(0)).setFocus();
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.rows.size()) {
            ExtensionAttributeRow row = (ExtensionAttributeRow)this.rows.get(i);
            row.dispose();
            ++i;
        }
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void refresh() {
        this.update();
        super.refresh();
    }
}

