/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.plugin.NewElementAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.ExtensionEditorWizard;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionWizard;
import org.eclipse.pde.ui.IExtensionEditorWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.DrillDownAdapter;

public class ExtensionsSection
extends TreeSection
implements IModelChangedListener {
    private TreeViewer extensionTree;
    private Image extensionImage;
    public static final String SECTION_TITLE = "ManifestEditor.DetailExtension.title";
    public static final String SECTION_NEW = "ManifestEditor.DetailExtension.new";
    public static final String SECTION_EDIT = "ManifestEditor.DetailExtension.edit";
    public static final String SECTION_DOWN = "ManifestEditor.DetailExtension.down";
    public static final String SECTION_UP = "ManifestEditor.DetailExtension.up";
    public static final String SECTION_SHOW_CHILDREN = "ManifestEditor.DetailExtension.showAllChildren";
    public static final String POPUP_NEW = "Menus.new.label";
    public static final String POPUP_EDIT = "Menus.edit.label";
    public static final String POPUP_NEW_EXTENSION = "ManifestEditor.DetailExtension.newExtension";
    public static final String POPUP_COLLAPSE_ALL = "ManifestEditor.DetailExtension.collapseAll";
    public static final String POPUP_GO_TO = "Menus.goTo.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    private Image genericElementImage;
    private SchemaRegistry schemaRegistry;
    private ExternalModelManager pluginInfoRegistry;
    private DrillDownAdapter drillDownAdapter;
    private Action newExtensionAction;
    private Action collapseAllAction;
    private Hashtable editorWizards;
    private static final String[] COMMON_LABEL_PROPERTIES = new String[]{"label", "name", "id"};

    public ExtensionsSection(PDEFormPage page, Composite parent) {
        String[] stringArray = new String[5];
        stringArray[0] = PDEPlugin.getResourceString(SECTION_NEW);
        stringArray[1] = PDEPlugin.getResourceString(SECTION_EDIT);
        stringArray[3] = PDEPlugin.getResourceString(SECTION_UP);
        stringArray[4] = PDEPlugin.getResourceString(SECTION_DOWN);
        super(page, parent, 0, stringArray);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.pluginInfoRegistry = PDECore.getDefault().getExternalModelManager();
        this.handleDefaultButton = false;
    }

    private static void addItemsForExtensionWithSchema(MenuManager menu, IPluginExtension extension, IPluginParent parent) {
        String tagName;
        ISchema schema = ExtensionsSection.getSchema(extension);
        ISchemaElement elementInfo = schema.findElement(tagName = parent == extension ? "extension" : parent.getName());
        if (elementInfo == null) {
            return;
        }
        ISchemaElement[] candidates = schema.getCandidateChildren(elementInfo);
        int i = 0;
        while (i < candidates.length) {
            ISchemaElement candidateInfo = candidates[i];
            NewElementAction action = new NewElementAction(candidateInfo, parent);
            menu.add((IAction)action);
            ++i;
        }
    }

    private static ISchema getSchema(IPluginExtension extension) {
        String point = extension.getPoint();
        SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
        return registry.getSchema(point);
    }

    static ISchemaElement getSchemaElement(IPluginElement element) {
        ISchema schema;
        IPluginObject parent = element.getParent();
        while (parent != null && !(parent instanceof IPluginExtension)) {
            parent = parent.getParent();
        }
        if (parent != null && (schema = ExtensionsSection.getSchema((IPluginExtension)parent)) != null) {
            return schema.findElement(element.getName());
        }
        return null;
    }

    public void createClient(Section section, FormToolkit toolkit) {
        this.initializeImages();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.extensionTree = treePart.getTreeViewer();
        this.extensionTree.setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.extensionTree.setLabelProvider((IBaseLabelProvider)new ExtensionLabelProvider());
        this.drillDownAdapter = new DrillDownAdapter(this.extensionTree);
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize((IPluginModelBase)this.getPage().getModel());
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateUpDownButtons(selection.getFirstElement());
        this.getTreePart().setButtonEnabled(1, this.isSelectionEditable(selection));
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleEdit();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.handleMove(true);
                break;
            }
            case 4: {
                this.handleMove(false);
            }
        }
    }

    public void dispose() {
        this.editorWizards = null;
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginExtension || object instanceof IPluginElement) {
            this.extensionTree.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object object;
        ISelection selection = this.extensionTree.getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        MenuManager newMenu = null;
        if (ssel.size() == 1) {
            IPluginParent parent;
            object = ssel.getFirstElement();
            if (object instanceof IPluginParent && (parent = (IPluginParent)object).getModel().getUnderlyingResource() != null) {
                newMenu = ExtensionsSection.fillContextMenu(this.getPage(), parent, manager);
                manager.add((IContributionItem)new Separator());
            }
        } else if (ssel.size() > 1) {
            Action delAction = new Action(){

                public void run() {
                    ExtensionsSection.this.handleDelete();
                }
            };
            delAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
            manager.add((IAction)delAction);
            manager.add((IContributionItem)new Separator());
            delAction.setEnabled(this.isEditable());
        }
        if (newMenu == null) {
            newMenu = new MenuManager(PDEPlugin.getResourceString(POPUP_NEW));
            manager.add((IContributionItem)newMenu);
        }
        if (!newMenu.isEmpty()) {
            newMenu.add((IContributionItem)new Separator());
        }
        newMenu.add((IAction)this.newExtensionAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        this.getPage().getPDEEditor().getContributor().addClipboardActions(manager);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
        if (ssel.size() == 1) {
            manager.add((IContributionItem)new Separator());
            object = ssel.getFirstElement();
            if (object instanceof IPluginExtension) {
                PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
                actionGroup.setContext(new ActionContext(selection));
                actionGroup.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator());
            }
        }
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager) {
        return ExtensionsSection.fillContextMenu(page, parent, manager, false);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager, boolean addSiblingItems) {
        return ExtensionsSection.fillContextMenu(page, parent, manager, addSiblingItems, true);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, final IPluginParent parent, IMenuManager manager, boolean addSiblingItems, boolean fullMenu) {
        MenuManager menu = new MenuManager(PDEPlugin.getResourceString(POPUP_NEW));
        IPluginExtension extension = ExtensionsSection.getExtension(parent);
        ISchema schema = ExtensionsSection.getSchema(extension);
        if (schema == null) {
            menu.add((IAction)new NewElementAction(null, parent));
        } else {
            IPluginObject parentsParent;
            ExtensionsSection.addItemsForExtensionWithSchema(menu, extension, parent);
            if (addSiblingItems && !((parentsParent = parent.getParent()) instanceof IPluginExtension)) {
                IPluginParent pparent = (IPluginParent)parentsParent;
                menu.add((IContributionItem)new Separator());
                ExtensionsSection.addItemsForExtensionWithSchema(menu, extension, pparent);
            }
        }
        manager.add((IContributionItem)menu);
        manager.add((IContributionItem)new Separator());
        if (fullMenu) {
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    try {
                        IPluginObject parentsParent = parent.getParent();
                        if (parent instanceof IPluginExtension) {
                            IPluginBase plugin = (IPluginBase)parentsParent;
                            plugin.remove((IPluginExtension)parent);
                        } else {
                            IPluginParent parentElement = (IPluginParent)parent.getParent();
                            parentElement.remove((IPluginObject)parent);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            deleteAction.setEnabled(page.getModel().isEditable());
            manager.add((IAction)deleteAction);
        }
        return menu;
    }

    static IPluginExtension getExtension(IPluginParent parent) {
        while (parent != null && !(parent instanceof IPluginExtension)) {
            parent = (IPluginParent)parent.getParent();
        }
        return (IPluginExtension)parent;
    }

    private void handleDelete() {
        IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            IPluginObject object = (IPluginObject)iter.next();
            try {
                if (object instanceof IPluginElement) {
                    IPluginElement ee = (IPluginElement)object;
                    IPluginParent parent = (IPluginParent)ee.getParent();
                    parent.remove((IPluginObject)ee);
                    continue;
                }
                if (!(object instanceof IPluginExtension)) continue;
                IPluginExtension extension = (IPluginExtension)object;
                IPluginBase plugin = extension.getPluginBase();
                plugin.remove(extension);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleNew() {
        final IProject project = this.getPage().getPDEEditor().getCommonProject();
        BusyIndicator.showWhile((Display)this.extensionTree.getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewExtensionWizard wizard = new NewExtensionWizard(project, (IPluginModelBase)ExtensionsSection.this.getPage().getModel(), (ManifestEditor)ExtensionsSection.this.getPage().getPDEEditor());
                WizardDialog dialog = new WizardDialog(this, PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected void finishPressed() {
                        ((ManifestEditor)3.access$0(this.this$1).getPage().getEditor()).ensurePluginContextPresence();
                        super.finishPressed();
                    }
                };
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                dialog.open();
            }

            static /* synthetic */ ExtensionsSection access$0(3 var0) {
                return var0.ExtensionsSection.this;
            }
        });
    }

    private void handleEdit(IConfigurationElement element, IStructuredSelection selection) {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        try {
            final IExtensionEditorWizard wizard = (IExtensionEditorWizard)element.createExecutableExtension("class");
            wizard.init(project, model, selection);
            BusyIndicator.showWhile((Display)this.extensionTree.getTree().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                    dialog.open();
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.extensionTree.getSelection();
        ArrayList editorWizards = this.getEditorWizards(selection);
        if (editorWizards == null) {
            return;
        }
        if (editorWizards.size() == 1) {
            this.handleEdit((IConfigurationElement)editorWizards.get(0), selection);
        } else {
            IProject project = this.getPage().getPDEEditor().getCommonProject();
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            final ExtensionEditorWizard wizard = new ExtensionEditorWizard(project, model, selection);
            BusyIndicator.showWhile((Display)this.extensionTree.getTree().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                    dialog.open();
                }
            });
        }
    }

    private ArrayList getEditorWizards(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object obj = selection.getFirstElement();
        String pointId = null;
        if (obj instanceof IPluginExtension) {
            pointId = ((IPluginExtension)obj).getPoint();
        } else if (obj instanceof IPluginElement) {
            IPluginObject parent = ((IPluginElement)obj).getParent();
            while (parent != null) {
                if (parent instanceof IPluginExtension) {
                    pointId = ((IPluginExtension)parent).getPoint();
                    break;
                }
                parent = parent.getParent();
            }
        }
        if (pointId == null) {
            return null;
        }
        if (this.editorWizards == null) {
            this.loadExtensionWizards();
        }
        return (ArrayList)this.editorWizards.get(pointId);
    }

    private void loadExtensionWizards() {
        this.editorWizards = new Hashtable();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.newExtension");
        int i = 0;
        while (i < elements.length) {
            String pointId;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("editorWizard") && (pointId = element.getAttribute("point")) != null) {
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)this.editorWizards.get(pointId);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    this.editorWizards.put(pointId, list);
                }
                list.add(element);
            }
            ++i;
        }
    }

    private boolean isSelectionEditable(IStructuredSelection selection) {
        if (!this.getPage().getModel().isEditable()) {
            return false;
        }
        return this.getEditorWizards(selection) != null;
    }

    void handleCollapseAll() {
        this.getTreePart().getTreeViewer().collapseAll();
    }

    public void initialize(IPluginModelBase model) {
        this.extensionTree.setInput((Object)model.getPluginBase());
        this.selectFirstExtension();
        boolean editable = model.isEditable();
        TreePart treePart = this.getTreePart();
        treePart.setButtonEnabled(0, editable);
        treePart.setButtonEnabled(1, false);
        treePart.setButtonEnabled(3, false);
        treePart.setButtonEnabled(4, false);
        model.addModelChangedListener((IModelChangedListener)this);
        this.newExtensionAction = new Action(){

            public void run() {
                ExtensionsSection.this.handleNew();
            }
        };
        this.newExtensionAction.setText(PDEPlugin.getResourceString(POPUP_NEW_EXTENSION));
        this.newExtensionAction.setImageDescriptor(PDEPluginImages.DESC_EXTENSION_OBJ);
        this.newExtensionAction.setEnabled(editable);
        this.collapseAllAction = new Action(){

            public void run() {
                ExtensionsSection.this.handleCollapseAll();
            }
        };
        this.collapseAllAction.setText(PDEPlugin.getResourceString(POPUP_COLLAPSE_ALL));
    }

    private void selectFirstExtension() {
        Tree tree = this.extensionTree.getTree();
        TreeItem[] items = tree.getItems();
        if (items.length == 0) {
            return;
        }
        TreeItem firstItem = items[0];
        Object obj = firstItem.getData();
        this.extensionTree.setSelection((ISelection)new StructuredSelection(obj));
    }

    void fireSelection() {
        this.extensionTree.setSelection(this.extensionTree.getSelection());
    }

    public void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.extensionImage = provider.get(PDEPluginImages.DESC_EXTENSION_OBJ);
        this.genericElementImage = provider.get(PDEPluginImages.DESC_GENERIC_XML_OBJ);
    }

    public void refresh() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        this.extensionTree.setInput((Object)model.getPluginBase());
        this.selectFirstExtension();
        this.getManagedForm().fireSelectionChanged((IFormPart)this, this.extensionTree.getSelection());
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginBase && event.getChangeType() == 3 && event.getChangedProperty().equals("extension_order")) {
            IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
            IPluginExtension extension = (IPluginExtension)sel.getFirstElement();
            this.extensionTree.refresh();
            this.extensionTree.setSelection((ISelection)new StructuredSelection((Object)extension));
            return;
        }
        if (changeObject instanceof IPluginExtension || changeObject instanceof IPluginElement && ((IPluginElement)changeObject).getParent() instanceof IPluginParent) {
            IPluginObject parent;
            IPluginObject pobj = (IPluginObject)changeObject;
            Object object = parent = changeObject instanceof IPluginExtension ? ((IPluginModelBase)this.getPage().getModel()).getPluginBase() : pobj.getParent();
            if (event.getChangeType() == 1) {
                this.extensionTree.add((Object)parent, (Object)pobj);
                this.extensionTree.setSelection((ISelection)new StructuredSelection(changeObject), true);
                this.extensionTree.getTree().setFocus();
            } else if (event.getChangeType() == 2) {
                this.extensionTree.remove((Object)pobj);
            } else if (event.getChangedProperty().equals("sibling_order")) {
                IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
                IPluginObject child = (IPluginObject)sel.getFirstElement();
                this.extensionTree.refresh((Object)child.getParent());
                this.extensionTree.setSelection((ISelection)new StructuredSelection((Object)child));
            } else {
                this.extensionTree.update(changeObject, null);
            }
        }
    }

    private Image resolveObjectImage(Object obj) {
        if (obj instanceof IPluginExtension) {
            return this.extensionImage;
        }
        Image elementImage = this.genericElementImage;
        if (obj instanceof IPluginElement) {
            String bodyText;
            boolean hasBodyText;
            IPluginElement element = (IPluginElement)obj;
            Image customImage = ExtensionsSection.getCustomImage(element);
            if (customImage != null) {
                elementImage = customImage;
            }
            boolean bl = hasBodyText = (bodyText = element.getText()) != null && bodyText.length() > 0;
            if (hasBodyText) {
                elementImage = PDEPlugin.getDefault().getLabelProvider().get(elementImage, 8);
            }
        }
        return elementImage;
    }

    static Image getCustomImage(IPluginElement element) {
        if (ExtensionsSection.isStorageModel((IPluginObject)element)) {
            return null;
        }
        ISchemaElement elementInfo = ExtensionsSection.getSchemaElement(element);
        if (elementInfo != null && elementInfo.getIconProperty() != null) {
            String iconProperty = elementInfo.getIconProperty();
            IPluginAttribute att = element.getAttribute(iconProperty);
            String iconPath = null;
            if (att != null && att.getValue() != null) {
                iconPath = att.getValue();
            }
            if (iconPath != null) {
                return ExtensionsSection.getImageFromPlugin(element, iconPath);
            }
        }
        return null;
    }

    private static boolean isStorageModel(IPluginObject object) {
        IPluginModelBase modelBase = object.getPluginModel();
        return modelBase.getInstallLocation() == null;
    }

    private static Image getImageFromPlugin(IPluginElement element, String iconPathName) {
        IPluginModelBase model = element.getPluginModel();
        if (model == null) {
            return null;
        }
        if (iconPathName.startsWith("%")) {
            return null;
        }
        URL modelURL = null;
        String path = model.getInstallLocation();
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IPath realPath = resource.getLocation().removeLastSegments(1);
            path = realPath.toOSString();
        }
        try {
            if (!path.startsWith("file:")) {
                path = "file:" + path;
            }
            modelURL = new URL(String.valueOf(path) + File.separator);
            return PDEPlugin.getDefault().getLabelProvider().getImageFromURL(modelURL, iconPathName);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String resolveObjectName(Object obj) {
        return ExtensionsSection.resolveObjectName(this.getSchemaRegistry(), this.pluginInfoRegistry, obj);
    }

    private SchemaRegistry getSchemaRegistry() {
        if (this.schemaRegistry == null) {
            this.schemaRegistry = PDECore.getDefault().getSchemaRegistry();
        }
        return this.schemaRegistry;
    }

    public static String resolveObjectName(SchemaRegistry schemaRegistry, ExternalModelManager pluginInfoRegistry, Object obj) {
        boolean fullNames = PDEPlugin.isFullNameModeEnabled();
        if (obj instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)obj;
            if (!fullNames) {
                return extension.getPoint();
            }
            if (extension.getName() != null) {
                return extension.getTranslatedName();
            }
            ISchema schema = schemaRegistry.getSchema(extension.getPoint());
            if (schema != null) {
                return schema.getName();
            }
            return extension.getPoint();
        }
        if (obj instanceof IPluginElement) {
            IPluginElement element = (IPluginElement)obj;
            String baseName = element.getName();
            String fullName = null;
            ISchemaElement elementInfo = ExtensionsSection.getSchemaElement(element);
            IPluginAttribute labelAtt = null;
            if (elementInfo != null && elementInfo.getLabelProperty() != null) {
                labelAtt = element.getAttribute(elementInfo.getLabelProperty());
            }
            if (labelAtt == null) {
                int i = 0;
                while (i < COMMON_LABEL_PROPERTIES.length) {
                    labelAtt = element.getAttribute(COMMON_LABEL_PROPERTIES[i]);
                    if (labelAtt != null) break;
                    ++i;
                }
                if (labelAtt == null && element.getAttributeCount() == 1) {
                    labelAtt = element.getAttributes()[0];
                }
            }
            if (labelAtt != null && labelAtt.getValue() != null) {
                fullName = ExtensionsSection.stripShortcuts(labelAtt.getValue());
            }
            fullName = element.getResourceString(fullName);
            if (fullNames) {
                return fullName != null ? fullName : baseName;
            }
            return fullName != null ? String.valueOf(fullName) + " (" + baseName + ")" : baseName;
        }
        return obj.toString();
    }

    public void setFocus() {
        if (this.extensionTree != null) {
            this.extensionTree.getTree().setFocus();
        }
    }

    public static String stripShortcuts(String input) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c != '&') {
                if (c == '@') break;
                output.append(c);
            }
            ++i;
        }
        return output.toString();
    }

    protected boolean canPaste(Object target, Object[] objects) {
        if (objects[0] instanceof IPluginExtension) {
            return true;
        }
        return objects[0] instanceof IPluginElement && target instanceof IPluginParent;
    }

    protected void doPaste(Object target, Object[] objects) {
    }

    private void handleMove(boolean up) {
        IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
        IPluginObject object = (IPluginObject)sel.getFirstElement();
        if (object instanceof IPluginElement) {
            IPluginParent parent = (IPluginParent)object.getParent();
            IPluginObject[] children = parent.getChildren();
            int index = parent.getIndexOf(object);
            int newIndex = up ? index - 1 : index + 1;
            IPluginObject child2 = children[newIndex];
            try {
                parent.swap(object, child2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        } else if (object instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)object;
            IPluginBase plugin = extension.getPluginBase();
            IPluginExtension[] extensions = plugin.getExtensions();
            int index = plugin.getIndexOf(extension);
            int newIndex = up ? index - 1 : index + 1;
            IPluginExtension e2 = extensions[newIndex];
            try {
                plugin.swap(extension, e2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void updateUpDownButtons(Object item) {
        if (!this.getPage().getModel().isEditable()) {
            return;
        }
        boolean upEnabled = false;
        boolean downEnabled = false;
        if (item != null) {
            if (item instanceof IPluginElement) {
                IPluginElement element = (IPluginElement)item;
                IPluginParent parent = (IPluginParent)element.getParent();
                int index = parent.getIndexOf((IPluginObject)element);
                if (index > 0) {
                    upEnabled = true;
                }
                if (index < parent.getChildCount() - 1) {
                    downEnabled = true;
                }
            } else if (item instanceof IPluginExtension) {
                IPluginExtension extension = (IPluginExtension)item;
                IExtensions extensions = (IExtensions)extension.getParent();
                int index = extensions.getIndexOf(extension);
                int size = extensions.getExtensions().length;
                if (index > 0) {
                    upEnabled = true;
                }
                if (index < size - 1) {
                    downEnabled = true;
                }
            }
        }
        this.getTreePart().setButtonEnabled(3, upEnabled);
        this.getTreePart().setButtonEnabled(4, downEnabled);
    }

    class ExtensionContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ExtensionContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            Object[] children = null;
            if (parent instanceof IPluginBase) {
                children = ((IPluginBase)parent).getExtensions();
            } else if (parent instanceof IPluginExtension) {
                children = ((IPluginExtension)parent).getChildren();
            } else if (parent instanceof IPluginElement) {
                children = ((IPluginElement)parent).getChildren();
            }
            if (children == null) {
                children = new Object[]{};
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginExtension) {
                return ((IPluginModelBase)ExtensionsSection.this.getPage().getModel()).getPluginBase();
            }
            if (child instanceof IPluginObject) {
                return ((IPluginObject)child).getParent();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }
    }

    class ExtensionLabelProvider
    extends LabelProvider {
        ExtensionLabelProvider() {
        }

        public String getText(Object obj) {
            return ExtensionsSection.this.resolveObjectName(obj);
        }

        public Image getImage(Object obj) {
            return ExtensionsSection.this.resolveObjectImage(obj);
        }
    }
}

