/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;

public class ElementSectionDragAdapter
extends DragSourceAdapter {
    ISelectionProvider selectionProvider;
    Object dragData;
    ElementSection section;

    public ElementSectionDragAdapter(ISelectionProvider provider, ElementSection section) {
        this.selectionProvider = provider;
        this.section = section;
    }

    public void dragSetData(DragSourceEvent event) {
        if (!event.doit) {
            return;
        }
        if (ModelDataTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getSelectedModelObjects();
            this.dragData = event.data;
            return;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = ElementSectionDragAdapter.createTextualRepresentation((IStructuredSelection)this.selectionProvider.getSelection());
            this.dragData = null;
            return;
        }
    }

    static String createTextualRepresentation(IStructuredSelection sel) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            buf.append(name);
            buf.append(" ");
        }
        return buf.toString();
    }

    public void dragStart(DragSourceEvent event) {
        DragSource dragSource = (DragSource)event.widget;
        Control control = dragSource.getControl();
        if (control != control.getDisplay().getFocusControl()) {
            event.doit = false;
            return;
        }
        event.doit = this.canDrag();
    }

    public void dragFinished(DragSourceEvent event) {
        if (!event.doit || this.dragData == null) {
            return;
        }
        if (event.detail == 2) {
            ISchemaObject[] objects = (ISchemaObject[])this.dragData;
            int i = 0;
            while (i < objects.length) {
                ISchemaObject obj = objects[i];
                this.section.handleDelete(obj);
                ++i;
            }
        }
        this.dragData = null;
    }

    private boolean canDrag() {
        return ElementSectionDragAdapter.canCopy((IStructuredSelection)this.selectionProvider.getSelection());
    }

    static boolean canCopy(IStructuredSelection selection) {
        Object prev = null;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ISchemaObject)) {
                return false;
            }
            if (prev != null) {
                if (prev.getClass().equals(obj.getClass())) continue;
                return false;
            }
            prev = obj;
        }
        return true;
    }

    private ISchemaObject[] getSelectedModelObjects() {
        return ElementSectionDragAdapter.createObjectRepresentation((IStructuredSelection)this.selectionProvider.getSelection());
    }

    static ISchemaObject[] createObjectRepresentation(IStructuredSelection selection) {
        ArrayList objects = new ArrayList();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof ISchemaObject) {
                objects.add(obj);
                continue;
            }
            return new ISchemaObject[0];
        }
        return objects.toArray(new ISchemaObject[objects.size()]);
    }
}

